/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util.lazytags;

import fr.xephi.authme.util.lazytags.Tag;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public final class TagReplacer<A> {
    private final List<Tag<A>> tags;
    private final Collection<String> messages;

    private TagReplacer(List<Tag<A>> tags, Collection<String> messages) {
        this.tags = tags;
        this.messages = messages;
    }

    public static <A> TagReplacer<A> newReplacer(Collection<Tag<A>> allTags, Collection<String> messages) {
        List<Tag<A>> usedTags = TagReplacer.determineUsedTags(allTags, messages);
        return new TagReplacer<A>(usedTags, messages);
    }

    public List<String> getAdaptedMessages(A argument) {
        LinkedList<TagValue> tagValues = new LinkedList<TagValue>();
        for (Tag<A> tag : this.tags) {
            tagValues.add(new TagValue(tag.getName(), tag.getValue(argument)));
        }
        LinkedList<String> adaptedMessages = new LinkedList<String>();
        Iterator<String> iterator = this.messages.iterator();
        while (iterator.hasNext()) {
            String line;
            String adaptedLine = line = iterator.next();
            for (TagValue tagValue : tagValues) {
                adaptedLine = adaptedLine.replace(tagValue.tag, tagValue.value);
            }
            adaptedMessages.add(adaptedLine);
        }
        return adaptedMessages;
    }

    private static <A> List<Tag<A>> determineUsedTags(Collection<Tag<A>> allTags, Collection<String> messages) {
        return allTags.stream().filter(tag -> messages.stream().anyMatch(msg -> msg.contains(tag.getName()))).collect(Collectors.toList());
    }

    private static final class TagValue {
        private final String tag;
        private final String value;

        TagValue(String tag, String value) {
            this.tag = tag;
            this.value = value;
        }

        public String toString() {
            return "TagValue[tag='" + this.tag + "', value='" + this.value + "']";
        }
    }
}

