/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util.expiring;

import fr.xephi.authme.util.expiring.ExpiringMap;
import java.util.concurrent.TimeUnit;

public class TimedCounter<K>
extends ExpiringMap<K, Integer> {
    public TimedCounter(long duration, TimeUnit unit) {
        super(duration, unit);
    }

    @Override
    public Integer get(K key) {
        Integer value = (Integer)super.get(key);
        return value == null ? 0 : value;
    }

    public void increment(K key) {
        this.put(key, (Integer)this.get((Object)key) + 1);
    }

    public void decrement(K key) {
        ExpiringMap.ExpiringEntry e = this.getEntries().get(key);
        if (e != null) {
            if ((Integer)e.getValue() <= 0) {
                this.remove(key);
            } else {
                this.getEntries().put(key, new ExpiringMap.ExpiringEntry<Integer>((Integer)e.getValue() - 1, e.getExpiration()));
            }
        }
    }

    public int total() {
        long currentTime = System.currentTimeMillis();
        return this.getEntries().values().stream().filter(entry -> currentTime <= entry.getExpiration()).map(ExpiringMap.ExpiringEntry::getValue).reduce(0, Integer::sum);
    }
}

