/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util.expiring;

import java.util.concurrent.TimeUnit;

public class Duration {
    private final long duration;
    private final TimeUnit unit;

    public Duration(long duration, TimeUnit unit) {
        this.duration = duration;
        this.unit = unit;
    }

    public static Duration createWithSuitableUnit(long sourceDuration, TimeUnit sourceUnit) {
        long durationMillis = Math.abs(TimeUnit.MILLISECONDS.convert(sourceDuration, sourceUnit));
        TimeUnit targetUnit = durationMillis > 86400000L ? TimeUnit.DAYS : (durationMillis > 3600000L ? TimeUnit.HOURS : (durationMillis > 60000L ? TimeUnit.MINUTES : TimeUnit.SECONDS));
        long durationInTargetUnit = targetUnit.convert(sourceDuration, sourceUnit);
        return new Duration(durationInTargetUnit, targetUnit);
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.unit;
    }
}

