/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.util.StringUtils;
import java.util.Collection;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

public final class Utils {
    public static final long MILLIS_PER_MINUTE = 60000L;
    private static ConsoleLogger logger = ConsoleLoggerFactory.get(Utils.class);

    private Utils() {
    }

    public static Pattern safePatternCompile(String pattern) {
        try {
            return Pattern.compile(pattern);
        }
        catch (Exception e) {
            logger.warning("Failed to compile pattern '" + pattern + "' - defaulting to allowing everything");
            return Pattern.compile(".*?");
        }
    }

    public static boolean isClassLoaded(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void logAndSendMessage(CommandSender sender, String message) {
        logger.info(message);
        if (sender != null && !(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage(message);
        }
    }

    public static void logAndSendWarning(CommandSender sender, String message) {
        logger.warning(message);
        if (sender != null && !(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + message);
        }
    }

    public static boolean isCollectionEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmailEmpty(String email) {
        return StringUtils.isBlank(email) || "your@email.com".equalsIgnoreCase(email);
    }
}

