/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util;

import net.ricecode.similarity.LevenshteinDistanceStrategy;
import net.ricecode.similarity.SimilarityStrategy;
import net.ricecode.similarity.StringSimilarityServiceImpl;

public final class StringUtils {
    private StringUtils() {
    }

    public static double getDifference(String first, String second) {
        if (first == null || second == null) {
            return 1.0;
        }
        StringSimilarityServiceImpl service = new StringSimilarityServiceImpl((SimilarityStrategy)new LevenshteinDistanceStrategy());
        return Math.abs(service.score(first, second) - 1.0);
    }

    public static boolean containsAny(String str, Iterable<String> pieces) {
        if (str == null) {
            return false;
        }
        for (String piece : pieces) {
            if (piece == null || !str.contains(piece)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isInsideString(char needle, String haystack) {
        int index = haystack.indexOf(needle);
        return index > 0 && index < haystack.length() - 1;
    }
}

