/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class InternetProtocolUtils {
    private InternetProtocolUtils() {
    }

    public static boolean isLocalAddress(String address) {
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            return InternetProtocolUtils.isLoopbackAddress(address) || inetAddress.isSiteLocalAddress() || inetAddress.isLinkLocalAddress() || InternetProtocolUtils.isIPv6UniqueSiteLocal(inetAddress);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isLoopbackAddress(String address) {
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            return inetAddress.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private static boolean isLoopbackAddress(InetAddress address) {
        return address.isLoopbackAddress();
    }

    private static boolean isIPv6UniqueSiteLocal(InetAddress address) {
        return (address.getAddress()[0] & 0xFF) == 252 || (address.getAddress()[0] & 0xFF) == 253;
    }
}

