/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public final class FileUtils {
    private static final DateTimeFormatter CURRENT_DATE_STRING_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HHmm");
    private static ConsoleLogger logger = ConsoleLoggerFactory.get(FileUtils.class);

    private FileUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFileFromResource(File destinationFile, String resourcePath) {
        if (destinationFile.exists()) {
            return true;
        }
        if (!FileUtils.createDirectory(destinationFile.getParentFile())) {
            logger.warning("Cannot create parent directories for '" + String.valueOf(destinationFile) + "'");
            return false;
        }
        try (InputStream is = FileUtils.getResourceFromJar(resourcePath);){
            if (is == null) {
                logger.warning(String.format("Cannot copy resource '%s' to file '%s': cannot load resource", resourcePath, destinationFile.getPath()));
                return false;
            }
            Files.copy(is, destinationFile.toPath(), new CopyOption[0]);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.logException(String.format("Cannot copy resource '%s' to file '%s':", resourcePath, destinationFile.getPath()), e);
        }
        return false;
    }

    public static boolean createDirectory(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            logger.warning("Could not create directory '" + String.valueOf(dir) + "'");
            return false;
        }
        return dir.isDirectory();
    }

    public static InputStream getResourceFromJar(String path) {
        String normalizedPath = path.replace("\\", "/");
        return AuthMe.class.getClassLoader().getResourceAsStream(normalizedPath);
    }

    public static void purgeDirectory(File directory) {
        if (!directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File target : files) {
            if (target.isDirectory()) {
                FileUtils.purgeDirectory(target);
            }
            FileUtils.delete(target);
        }
    }

    public static void delete(File file) {
        boolean result;
        if (file != null && !(result = file.delete())) {
            logger.warning("Could not delete file '" + String.valueOf(file) + "'");
        }
    }

    public static void create(File file) {
        try {
            boolean result = file.createNewFile();
            if (!result) {
                throw new IllegalStateException("Could not create file '" + String.valueOf(file) + "'");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while creating file '" + String.valueOf(file) + "'", e);
        }
    }

    public static String makePath(String ... elements) {
        return String.join((CharSequence)File.separator, elements);
    }

    public static String createCurrentTimeString() {
        return LocalDateTime.now().format(CURRENT_DATE_STRING_FORMATTER);
    }

    public static String createBackupFilePath(File file) {
        String filename = "backup_" + com.google.common.io.Files.getNameWithoutExtension((String)file.getName()) + "_" + FileUtils.createCurrentTimeString() + "." + com.google.common.io.Files.getFileExtension((String)file.getName());
        return FileUtils.makePath(file.getParent(), filename);
    }
}

