/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.task.purge;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.PluginHookService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PurgeSettings;
import fr.xephi.authme.util.FileUtils;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;

public class PurgeExecutor {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(PurgeExecutor.class);
    @Inject
    private Settings settings;
    @Inject
    private DataSource dataSource;
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private PluginHookService pluginHookService;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private Server server;

    PurgeExecutor() {
    }

    public void executePurge(Collection<OfflinePlayer> players, Collection<String> names) {
        this.purgeFromAuthMe(names);
        this.purgeEssentials(players);
        this.purgeDat(players);
        this.purgeLimitedCreative(names);
        this.purgeAntiXray(names);
        this.purgePermissions(players);
    }

    synchronized void purgeAntiXray(Collection<String> cleared) {
        if (!((Boolean)this.settings.getProperty(PurgeSettings.REMOVE_ANTI_XRAY_FILE)).booleanValue()) {
            return;
        }
        int i = 0;
        File dataFolder = new File(FileUtils.makePath(".", "plugins", "AntiXRayData", "PlayerData"));
        if (!dataFolder.exists() || !dataFolder.isDirectory()) {
            return;
        }
        for (String file : dataFolder.list()) {
            File playerFile;
            if (!cleared.contains(file.toLowerCase(Locale.ROOT)) || !(playerFile = new File(dataFolder, file)).exists() || !playerFile.delete()) continue;
            ++i;
        }
        this.logger.info("AutoPurge: Removed " + i + " AntiXRayData Files");
    }

    synchronized void purgeFromAuthMe(Collection<String> names) {
        this.dataSource.purgeRecords(names);
        this.logger.info(String.valueOf(ChatColor.GOLD) + "Deleted " + names.size() + " user accounts");
    }

    synchronized void purgeLimitedCreative(Collection<String> cleared) {
        if (!((Boolean)this.settings.getProperty(PurgeSettings.REMOVE_LIMITED_CREATIVE_INVENTORIES)).booleanValue()) {
            return;
        }
        int i = 0;
        File dataFolder = new File(FileUtils.makePath(".", "plugins", "LimitedCreative", "inventories"));
        if (!dataFolder.exists() || !dataFolder.isDirectory()) {
            return;
        }
        String[] stringArray = dataFolder.list();
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            File dataFile;
            String file;
            String name = file = stringArray[j];
            int idx = file.lastIndexOf("_creative.yml");
            if (idx != -1) {
                name = name.substring(0, idx);
            } else {
                idx = file.lastIndexOf("_adventure.yml");
                if (idx != -1) {
                    name = name.substring(0, idx);
                } else {
                    idx = file.lastIndexOf(".yml");
                    if (idx != -1) {
                        name = name.substring(0, idx);
                    }
                }
            }
            if (name.equals(file) || !cleared.contains(name.toLowerCase(Locale.ROOT)) || !(dataFile = new File(dataFolder, file)).exists() || !dataFile.delete()) continue;
            ++i;
        }
        this.logger.info("AutoPurge: Removed " + i + " LimitedCreative Survival, Creative and Adventure files");
    }

    synchronized void purgeDat(Collection<OfflinePlayer> cleared) {
        if (!((Boolean)this.settings.getProperty(PurgeSettings.REMOVE_PLAYER_DAT)).booleanValue()) {
            return;
        }
        int i = 0;
        File dataFolder = new File(this.server.getWorldContainer(), FileUtils.makePath((String)this.settings.getProperty(PurgeSettings.DEFAULT_WORLD), "players"));
        for (OfflinePlayer offlinePlayer : cleared) {
            File playerFile = new File(dataFolder, String.valueOf(offlinePlayer.getUniqueId()) + ".dat");
            if (!playerFile.delete()) continue;
            ++i;
        }
        this.logger.info("AutoPurge: Removed " + i + " .dat Files");
    }

    synchronized void purgeEssentials(Collection<OfflinePlayer> cleared) {
        if (!((Boolean)this.settings.getProperty(PurgeSettings.REMOVE_ESSENTIALS_FILES)).booleanValue()) {
            return;
        }
        File essentialsDataFolder = this.pluginHookService.getEssentialsDataFolder();
        if (essentialsDataFolder == null) {
            this.logger.info("Cannot purge Essentials: plugin is not loaded");
            return;
        }
        File userDataFolder = new File(essentialsDataFolder, "userdata");
        if (!userDataFolder.exists() || !userDataFolder.isDirectory()) {
            return;
        }
        int deletedFiles = 0;
        for (OfflinePlayer offlinePlayer : cleared) {
            File playerFile = new File(userDataFolder, String.valueOf(offlinePlayer.getUniqueId()) + ".yml");
            if (!playerFile.exists() || !playerFile.delete()) continue;
            ++deletedFiles;
        }
        this.logger.info("AutoPurge: Removed " + deletedFiles + " EssentialsFiles");
    }

    synchronized void purgePermissions(Collection<OfflinePlayer> cleared) {
        if (!((Boolean)this.settings.getProperty(PurgeSettings.REMOVE_PERMISSIONS)).booleanValue()) {
            return;
        }
        for (OfflinePlayer offlinePlayer : cleared) {
            if (!this.permissionsManager.loadUserData(offlinePlayer)) {
                this.logger.warning("Unable to purge the permissions of user " + String.valueOf(offlinePlayer) + "!");
                continue;
            }
            this.permissionsManager.removeAllGroups(offlinePlayer);
        }
        this.logger.info("AutoPurge: Removed permissions from " + cleared.size() + " player(s).");
    }
}

