/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.properties;

import ch.jalu.configme.Comment;
import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.PropertyInitializer;
import fr.xephi.authme.security.HashAlgorithm;
import fr.xephi.authme.settings.EnumSetProperty;
import java.util.Set;

public final class SecuritySettings
implements SettingsHolder {
    @Comment(value={"Stop the server if we can't contact the sql database", "Take care with this, if you set this to false,", "AuthMe will automatically disable and the server won't be protected!"})
    public static final Property<Boolean> STOP_SERVER_ON_PROBLEM = PropertyInitializer.newProperty((String)"Security.SQLProblem.stopServer", (boolean)true);
    @Comment(value={"Copy AuthMe log output in a separate file as well?"})
    public static final Property<Boolean> USE_LOGGING = PropertyInitializer.newProperty((String)"Security.console.logConsole", (boolean)true);
    @Comment(value={"Enable captcha when a player uses wrong password too many times"})
    public static final Property<Boolean> ENABLE_LOGIN_FAILURE_CAPTCHA = PropertyInitializer.newProperty((String)"Security.captcha.useCaptcha", (boolean)false);
    @Comment(value={"Max allowed tries before a captcha is required"})
    public static final Property<Integer> MAX_LOGIN_TRIES_BEFORE_CAPTCHA = PropertyInitializer.newProperty((String)"Security.captcha.maxLoginTry", (int)5);
    @Comment(value={"Captcha length"})
    public static final Property<Integer> CAPTCHA_LENGTH = PropertyInitializer.newProperty((String)"Security.captcha.captchaLength", (int)5);
    @Comment(value={"Minutes after which login attempts count is reset for a player"})
    public static final Property<Integer> CAPTCHA_COUNT_MINUTES_BEFORE_RESET = PropertyInitializer.newProperty((String)"Security.captcha.captchaCountReset", (int)60);
    @Comment(value={"Require captcha before a player may register?"})
    public static final Property<Boolean> ENABLE_CAPTCHA_FOR_REGISTRATION = PropertyInitializer.newProperty((String)"Security.captcha.requireForRegistration", (boolean)false);
    @Comment(value={"Minimum length of password"})
    public static final Property<Integer> MIN_PASSWORD_LENGTH = PropertyInitializer.newProperty((String)"settings.security.minPasswordLength", (int)5);
    @Comment(value={"Maximum length of password"})
    public static final Property<Integer> MAX_PASSWORD_LENGTH = PropertyInitializer.newProperty((String)"settings.security.passwordMaxLength", (int)30);
    @Comment(value={"Possible values: SHA256, BCRYPT, BCRYPT2Y, PBKDF2, SALTEDSHA512,", "MYBB, IPB3, PHPBB, PHPFUSION, SMF, XENFORO, XAUTH, JOOMLA, WBB3, WBB4, MD5VB,", "PBKDF2DJANGO, WORDPRESS, ROYALAUTH, ARGON2, CUSTOM (for developers only). See full list at", "https://github.com/AuthMe/AuthMeReloaded/blob/master/docs/hash_algorithms.md", "If you use ARGON2, check that you have the argon2 c library on your system"})
    public static final Property<HashAlgorithm> PASSWORD_HASH = PropertyInitializer.newProperty(HashAlgorithm.class, (String)"settings.security.passwordHash", (Enum)HashAlgorithm.SHA256);
    @Comment(value={"If a password check fails, AuthMe will also try to check with the following hash methods.", "Use this setting when you change from one hash method to another.", "AuthMe will update the password to the new hash. Example:", "legacyHashes:", "- 'SHA1'"})
    public static final Property<Set<HashAlgorithm>> LEGACY_HASHES = new EnumSetProperty(HashAlgorithm.class, "settings.security.legacyHashes", (Enum[])new HashAlgorithm[0]);
    @Comment(value={"Salt length for the SALTED2MD5 MD5(MD5(password)+salt)"})
    public static final Property<Integer> DOUBLE_MD5_SALT_LENGTH = PropertyInitializer.newProperty((String)"settings.security.doubleMD5SaltLength", (int)8);
    @Comment(value={"Number of rounds to use if passwordHash is set to PBKDF2. Default is 10000"})
    public static final Property<Integer> PBKDF2_NUMBER_OF_ROUNDS = PropertyInitializer.newProperty((String)"settings.security.pbkdf2Rounds", (int)10000);
    @Comment(value={"Prevent unsafe passwords from being used; put them in lowercase!", "You should always set 'help' as unsafePassword due to possible conflicts.", "unsafePasswords:", "- '123456'", "- 'password'", "- 'help'"})
    public static final Property<Set<String>> UNSAFE_PASSWORDS = PropertyInitializer.newLowercaseStringSetProperty((String)"settings.security.unsafePasswords", (String[])new String[]{"123456", "password", "qwerty", "12345", "54321", "123456789", "help"});
    @Comment(value={"Tempban a user's IP address if they enter the wrong password too many times"})
    public static final Property<Boolean> TEMPBAN_ON_MAX_LOGINS = PropertyInitializer.newProperty((String)"Security.tempban.enableTempban", (boolean)false);
    @Comment(value={"How many times a user can attempt to login before their IP being tempbanned"})
    public static final Property<Integer> MAX_LOGIN_TEMPBAN = PropertyInitializer.newProperty((String)"Security.tempban.maxLoginTries", (int)10);
    @Comment(value={"The length of time a IP address will be tempbanned in minutes", "Default: 480 minutes, or 8 hours"})
    public static final Property<Integer> TEMPBAN_LENGTH = PropertyInitializer.newProperty((String)"Security.tempban.tempbanLength", (int)480);
    @Comment(value={"How many minutes before resetting the count for failed logins by IP and username", "Default: 480 minutes (8 hours)"})
    public static final Property<Integer> TEMPBAN_MINUTES_BEFORE_RESET = PropertyInitializer.newProperty((String)"Security.tempban.minutesBeforeCounterReset", (int)480);
    @Comment(value={"The command to execute instead of using the internal ban system, empty if disabled.", "Available placeholders: %player%, %ip%"})
    public static final Property<String> TEMPBAN_CUSTOM_COMMAND = PropertyInitializer.newProperty((String)"Security.tempban.customCommand", (String)"");
    @Comment(value={"Number of characters a recovery code should have (0 to disable)"})
    public static final Property<Integer> RECOVERY_CODE_LENGTH = PropertyInitializer.newProperty((String)"Security.recoveryCode.length", (int)8);
    @Comment(value={"How many hours is a recovery code valid for?"})
    public static final Property<Integer> RECOVERY_CODE_HOURS_VALID = PropertyInitializer.newProperty((String)"Security.recoveryCode.validForHours", (int)4);
    @Comment(value={"Max number of tries to enter recovery code"})
    public static final Property<Integer> RECOVERY_CODE_MAX_TRIES = PropertyInitializer.newProperty((String)"Security.recoveryCode.maxTries", (int)3);
    @Comment(value={"How long a player has after password recovery to change their password", "without logging in. This is in minutes.", "Default: 2 minutes"})
    public static final Property<Integer> PASSWORD_CHANGE_TIMEOUT = PropertyInitializer.newProperty((String)"Security.recoveryCode.passwordChangeTimeout", (int)2);
    @Comment(value={"Seconds a user has to wait for before a password recovery mail may be sent again", "This prevents an attacker from abusing AuthMe's email feature."})
    public static final Property<Integer> EMAIL_RECOVERY_COOLDOWN_SECONDS = PropertyInitializer.newProperty((String)"Security.emailRecovery.cooldown", (int)60);
    @Comment(value={"The mail shown using /email show will be partially hidden", "E.g. (if enabled)", " original email: my.email@example.com", " hidden email: my.***@***mple.com"})
    public static final Property<Boolean> USE_EMAIL_MASKING = PropertyInitializer.newProperty((String)"Security.privacy.enableEmailMasking", (boolean)false);
    @Comment(value={"Minutes after which a verification code will expire"})
    public static final Property<Integer> VERIFICATION_CODE_EXPIRATION_MINUTES = PropertyInitializer.newProperty((String)"Security.privacy.verificationCodeExpiration", (int)10);

    private SecuritySettings() {
    }
}

