/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.properties;

import ch.jalu.configme.Comment;
import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.PropertyInitializer;
import java.util.List;
import java.util.Set;

public final class RestrictionSettings
implements SettingsHolder {
    @Comment(value={"Can not authenticated players chat?", "Keep in mind that this feature also blocks all commands not", "listed in the list below."})
    public static final Property<Boolean> ALLOW_CHAT = PropertyInitializer.newProperty((String)"settings.restrictions.allowChat", (boolean)false);
    @Comment(value={"Hide the chat log from players who are not authenticated?"})
    public static final Property<Boolean> HIDE_CHAT = PropertyInitializer.newProperty((String)"settings.restrictions.hideChat", (boolean)false);
    @Comment(value={"Allowed commands for unauthenticated players"})
    public static final Property<Set<String>> ALLOW_COMMANDS = PropertyInitializer.newLowercaseStringSetProperty((String)"settings.restrictions.allowCommands", (String[])new String[]{"/login", "/log", "/l", "/register", "/reg", "/email", "/captcha", "/2fa", "/totp"});
    @Comment(value={"Max number of allowed registrations per IP", "The value 0 means an unlimited number of registrations!"})
    public static final Property<Integer> MAX_REGISTRATION_PER_IP = PropertyInitializer.newProperty((String)"settings.restrictions.maxRegPerIp", (int)1);
    @Comment(value={"Minimum allowed username length"})
    public static final Property<Integer> MIN_NICKNAME_LENGTH = PropertyInitializer.newProperty((String)"settings.restrictions.minNicknameLength", (int)3);
    @Comment(value={"Maximum allowed username length"})
    public static final Property<Integer> MAX_NICKNAME_LENGTH = PropertyInitializer.newProperty((String)"settings.restrictions.maxNicknameLength", (int)16);
    @Comment(value={"When this setting is enabled, online players can't be kicked out", "due to \"Logged in from another Location\"", "This setting will prevent potential security exploits."})
    public static final Property<Boolean> FORCE_SINGLE_SESSION = PropertyInitializer.newProperty((String)"settings.restrictions.ForceSingleSession", (boolean)true);
    @Comment(value={"If enabled, every player that spawn in one of the world listed in", "\"ForceSpawnLocOnJoin.worlds\" will be teleported to the spawnpoint after successful", "authentication. The quit location of the player will be overwritten.", "This is different from \"teleportUnAuthedToSpawn\" that teleport player", "to the spawnpoint on join."})
    public static final Property<Boolean> FORCE_SPAWN_LOCATION_AFTER_LOGIN = PropertyInitializer.newProperty((String)"settings.restrictions.ForceSpawnLocOnJoin.enabled", (boolean)false);
    @Comment(value={"WorldNames where we need to force the spawn location", "Case-sensitive!"})
    public static final Property<List<String>> FORCE_SPAWN_ON_WORLDS = PropertyInitializer.newListProperty((String)"settings.restrictions.ForceSpawnLocOnJoin.worlds", (String[])new String[]{"world", "world_nether", "world_the_end"});
    @Comment(value={"This option will save the quit location of the players."})
    public static final Property<Boolean> SAVE_QUIT_LOCATION = PropertyInitializer.newProperty((String)"settings.restrictions.SaveQuitLocation", (boolean)false);
    @Comment(value={"To activate the restricted user feature you need", "to enable this option and configure the AllowedRestrictedUser field."})
    public static final Property<Boolean> ENABLE_RESTRICTED_USERS = PropertyInitializer.newProperty((String)"settings.restrictions.AllowRestrictedUser", (boolean)false);
    @Comment(value={"The restricted user feature will kick players listed below", "if they don't match the defined IP address. Names are case-insensitive.", "You can use * as wildcard (127.0.0.*), or regex with a \"regex:\" prefix regex:127\\.0\\.0\\..*", "Example:", "    AllowedRestrictedUser:", "    - playername;127.0.0.1", "    - playername;regex:127\\.0\\.0\\..*"})
    public static final Property<Set<String>> RESTRICTED_USERS = PropertyInitializer.newLowercaseStringSetProperty((String)"settings.restrictions.AllowedRestrictedUser", (String[])new String[0]);
    @Comment(value={"Ban unknown IPs trying to log in with a restricted username?"})
    public static final Property<Boolean> BAN_UNKNOWN_IP = PropertyInitializer.newProperty((String)"settings.restrictions.banUnsafedIP", (boolean)false);
    @Comment(value={"Should unregistered players be kicked immediately?"})
    public static final Property<Boolean> KICK_NON_REGISTERED = PropertyInitializer.newProperty((String)"settings.restrictions.kickNonRegistered", (boolean)false);
    @Comment(value={"Should players be kicked on wrong password?"})
    public static final Property<Boolean> KICK_ON_WRONG_PASSWORD = PropertyInitializer.newProperty((String)"settings.restrictions.kickOnWrongPassword", (boolean)true);
    @Comment(value={"Should not logged in players be teleported to the spawn?", "After the authentication they will be teleported back to", "their normal position."})
    public static final Property<Boolean> TELEPORT_UNAUTHED_TO_SPAWN = PropertyInitializer.newProperty((String)"settings.restrictions.teleportUnAuthedToSpawn", (boolean)false);
    @Comment(value={"Can unregistered players walk around?"})
    public static final Property<Boolean> ALLOW_UNAUTHED_MOVEMENT = PropertyInitializer.newProperty((String)"settings.restrictions.allowMovement", (boolean)false);
    @Comment(value={"After how many seconds should players who fail to login or register", "be kicked? Set to 0 to disable."})
    public static final Property<Integer> TIMEOUT = PropertyInitializer.newProperty((String)"settings.restrictions.timeout", (int)30);
    @Comment(value={"Regex pattern of allowed characters in the player name."})
    public static final Property<String> ALLOWED_NICKNAME_CHARACTERS = PropertyInitializer.newProperty((String)"settings.restrictions.allowedNicknameCharacters", (String)"[a-zA-Z0-9_]*");
    @Comment(value={"How far can unregistered players walk?", "Set to 0 for unlimited radius"})
    public static final Property<Integer> ALLOWED_MOVEMENT_RADIUS = PropertyInitializer.newProperty((String)"settings.restrictions.allowedMovementRadius", (int)100);
    @Comment(value={"Should we protect the player inventory before logging in? Requires ProtocolLib."})
    public static final Property<Boolean> PROTECT_INVENTORY_BEFORE_LOGIN = PropertyInitializer.newProperty((String)"settings.restrictions.ProtectInventoryBeforeLogIn", (boolean)true);
    @Comment(value={"Should we deny the tabcomplete feature before logging in? Requires ProtocolLib."})
    public static final Property<Boolean> DENY_TABCOMPLETE_BEFORE_LOGIN = PropertyInitializer.newProperty((String)"settings.restrictions.DenyTabCompleteBeforeLogin", (boolean)false);
    @Comment(value={"Should we display all other accounts from a player when he joins?", "permission: /authme.admin.accounts"})
    public static final Property<Boolean> DISPLAY_OTHER_ACCOUNTS = PropertyInitializer.newProperty((String)"settings.restrictions.displayOtherAccounts", (boolean)true);
    @Comment(value={"Spawn priority; values: authme, essentials, cmi, multiverse, default"})
    public static final Property<String> SPAWN_PRIORITY = PropertyInitializer.newProperty((String)"settings.restrictions.spawnPriority", (String)"authme,essentials,cmi,multiverse,default");
    @Comment(value={"Maximum Login authorized by IP"})
    public static final Property<Integer> MAX_LOGIN_PER_IP = PropertyInitializer.newProperty((String)"settings.restrictions.maxLoginPerIp", (int)0);
    @Comment(value={"Maximum Join authorized by IP"})
    public static final Property<Integer> MAX_JOIN_PER_IP = PropertyInitializer.newProperty((String)"settings.restrictions.maxJoinPerIp", (int)0);
    @Comment(value={"AuthMe will NEVER teleport players if set to true!"})
    public static final Property<Boolean> NO_TELEPORT = PropertyInitializer.newProperty((String)"settings.restrictions.noTeleport", (boolean)false);
    @Comment(value={"Regex syntax for allowed chars in passwords. The default [!-~] allows all visible ASCII", "characters, which is what we recommend. See also http://asciitable.com", "You can test your regex with https://regex101.com"})
    public static final Property<String> ALLOWED_PASSWORD_REGEX = PropertyInitializer.newProperty((String)"settings.restrictions.allowedPasswordCharacters", (String)"[!-~]*");
    @Comment(value={"Force survival gamemode when player joins?"})
    public static final Property<Boolean> FORCE_SURVIVAL_MODE = PropertyInitializer.newProperty((String)"settings.GameMode.ForceSurvivalMode", (boolean)false);
    @Comment(value={"Below you can list all account names that AuthMe will ignore", "for registration or login. Configure it at your own risk!!", "This option adds compatibility with BuildCraft and some other mods.", "It is case-insensitive! Example:", "UnrestrictedName:", "- 'npcPlayer'", "- 'npcPlayer2'"})
    public static final Property<Set<String>> UNRESTRICTED_NAMES = PropertyInitializer.newLowercaseStringSetProperty((String)"settings.unrestrictions.UnrestrictedName", (String[])new String[0]);
    @Comment(value={"Below you can list all inventories names that AuthMe will ignore", "for registration or login. Configure it at your own risk!!", "This option adds compatibility with some mods.", "It is case-insensitive! Example:", "UnrestrictedInventories:", "- 'myCustomInventory1'", "- 'myCustomInventory2'"})
    public static final Property<Set<String>> UNRESTRICTED_INVENTORIES = PropertyInitializer.newLowercaseStringSetProperty((String)"settings.unrestrictions.UnrestrictedInventories", (String[])new String[0]);

    private RestrictionSettings() {
    }
}

