/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.properties;

import ch.jalu.configme.Comment;
import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.PropertyInitializer;
import fr.xephi.authme.process.register.RegisterSecondaryArgument;
import fr.xephi.authme.process.register.RegistrationType;

public final class RegistrationSettings
implements SettingsHolder {
    @Comment(value={"Enable registration on the server?"})
    public static final Property<Boolean> IS_ENABLED = PropertyInitializer.newProperty((String)"settings.registration.enabled", (boolean)true);
    @Comment(value={"Send every X seconds a message to a player to", "remind him that he has to login/register"})
    public static final Property<Integer> MESSAGE_INTERVAL = PropertyInitializer.newProperty((String)"settings.registration.messageInterval", (int)5);
    @Comment(value={"Only registered and logged in players can play.", "See restrictions for exceptions"})
    public static final Property<Boolean> FORCE = PropertyInitializer.newProperty((String)"settings.registration.force", (boolean)true);
    @Comment(value={"Type of registration: PASSWORD or EMAIL", "PASSWORD = account is registered with a password supplied by the user;", "EMAIL = password is generated and sent to the email provided by the user.", "More info at https://github.com/AuthMe/AuthMeReloaded/wiki/Registration"})
    public static final Property<RegistrationType> REGISTRATION_TYPE = PropertyInitializer.newProperty(RegistrationType.class, (String)"settings.registration.type", (Enum)RegistrationType.PASSWORD);
    @Comment(value={"Second argument the /register command should take: NONE = no 2nd argument", "CONFIRMATION = must repeat first argument (pass or email)", "EMAIL_OPTIONAL = for password register: 2nd argument can be empty or have email address", "EMAIL_MANDATORY = for password register: 2nd argument MUST be an email address"})
    public static final Property<RegisterSecondaryArgument> REGISTER_SECOND_ARGUMENT = PropertyInitializer.newProperty(RegisterSecondaryArgument.class, (String)"settings.registration.secondArg", (Enum)RegisterSecondaryArgument.CONFIRMATION);
    @Comment(value={"Do we force kick a player after a successful registration?", "Do not use with login feature below"})
    public static final Property<Boolean> FORCE_KICK_AFTER_REGISTER = PropertyInitializer.newProperty((String)"settings.registration.forceKickAfterRegister", (boolean)false);
    @Comment(value={"Does AuthMe need to enforce a /login after a successful registration?"})
    public static final Property<Boolean> FORCE_LOGIN_AFTER_REGISTER = PropertyInitializer.newProperty((String)"settings.registration.forceLoginAfterRegister", (boolean)false);
    @Comment(value={"Enable to display the welcome message (welcome.txt) after a login", "You can use colors in this welcome.txt + some replaced strings:", "{PLAYER}: player name, {ONLINE}: display number of online players,", "{MAXPLAYERS}: display server slots, {IP}: player ip, {LOGINS}: number of players logged,", "{WORLD}: player current world, {SERVER}: server name", "{VERSION}: get current bukkit version, {COUNTRY}: player country"})
    public static final Property<Boolean> USE_WELCOME_MESSAGE = PropertyInitializer.newProperty((String)"settings.useWelcomeMessage", (boolean)true);
    @Comment(value={"Broadcast the welcome message to the server or only to the player?", "set true for server or false for player"})
    public static final Property<Boolean> BROADCAST_WELCOME_MESSAGE = PropertyInitializer.newProperty((String)"settings.broadcastWelcomeMessage", (boolean)false);
    @Comment(value={"Should we delay the join message and display it once the player has logged in?"})
    public static final Property<Boolean> DELAY_JOIN_MESSAGE = PropertyInitializer.newProperty((String)"settings.delayJoinMessage", (boolean)false);
    @Comment(value={"The custom join message that will be sent after a successful login,", "keep empty to use the original one.", "Available variables:", "{PLAYERNAME}: the player name (no colors)", "{DISPLAYNAME}: the player display name (with colors)", "{DISPLAYNAMENOCOLOR}: the player display name (without colors)"})
    public static final Property<String> CUSTOM_JOIN_MESSAGE = PropertyInitializer.newProperty((String)"settings.customJoinMessage", (String)"");
    @Comment(value={"Should we remove the leave messages of unlogged users?"})
    public static final Property<Boolean> REMOVE_UNLOGGED_LEAVE_MESSAGE = PropertyInitializer.newProperty((String)"settings.removeUnloggedLeaveMessage", (boolean)false);
    @Comment(value={"Should we remove join messages altogether?"})
    public static final Property<Boolean> REMOVE_JOIN_MESSAGE = PropertyInitializer.newProperty((String)"settings.removeJoinMessage", (boolean)false);
    @Comment(value={"Should we remove leave messages altogether?"})
    public static final Property<Boolean> REMOVE_LEAVE_MESSAGE = PropertyInitializer.newProperty((String)"settings.removeLeaveMessage", (boolean)false);
    @Comment(value={"Do we need to add potion effect Blinding before login/register?"})
    public static final Property<Boolean> APPLY_BLIND_EFFECT = PropertyInitializer.newProperty((String)"settings.applyBlindEffect", (boolean)false);
    @Comment(value={"Do we need to prevent people to login with another case?", "If Xephi is registered, then Xephi can login, but not XEPHI/xephi/XePhI"})
    public static final Property<Boolean> PREVENT_OTHER_CASE = PropertyInitializer.newProperty((String)"settings.preventOtherCase", (boolean)true);

    private RegistrationSettings() {
    }
}

