/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.properties;

import ch.jalu.configme.Comment;
import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.PropertyInitializer;
import java.util.List;

public final class ProtectionSettings
implements SettingsHolder {
    @Comment(value={"Enable some servers protection (country based login, antibot)"})
    public static final Property<Boolean> ENABLE_PROTECTION = PropertyInitializer.newProperty((String)"Protection.enableProtection", (boolean)false);
    @Comment(value={"Apply the protection also to registered usernames"})
    public static final Property<Boolean> ENABLE_PROTECTION_REGISTERED = PropertyInitializer.newProperty((String)"Protection.enableProtectionRegistered", (boolean)true);
    @Comment(value={"Enable GeoIp database"})
    public static final Property<Boolean> ENABLE_GEOIP = PropertyInitializer.newProperty((String)"Protection.geoIpDatabase.enabled", (boolean)true);
    @Comment(value={"The MaxMind clientId used to download the GeoIp database,", "get one at https://www.maxmind.com/en/accounts/current/license-key", "The EssentialsX project has a very useful tutorial on how to generate", "the license key: https://github.com/EssentialsX/Wiki/blob/master/GeoIP.md"})
    public static final Property<String> MAXMIND_API_CLIENT_ID = PropertyInitializer.newProperty((String)"Protection.geoIpDatabase.clientId", (String)"");
    @Comment(value={"The MaxMind licenseKey used to download the GeoIp database."})
    public static final Property<String> MAXMIND_API_LICENSE_KEY = PropertyInitializer.newProperty((String)"Protection.geoIpDatabase.licenseKey", (String)"");
    @Comment(value={"Countries allowed to join the server and register. For country codes, see", "https://dev.maxmind.com/geoip/legacy/codes/iso3166/", "Use \"LOCALHOST\" for local addresses.", "PLEASE USE QUOTES!"})
    public static final Property<List<String>> COUNTRIES_WHITELIST = PropertyInitializer.newListProperty((String)"Protection.countries", (String[])new String[]{"US", "GB", "LOCALHOST"});
    @Comment(value={"Countries not allowed to join the server and register", "PLEASE USE QUOTES!"})
    public static final Property<List<String>> COUNTRIES_BLACKLIST = PropertyInitializer.newListProperty((String)"Protection.countriesBlacklist", (String[])new String[]{"A1"});
    @Comment(value={"Do we need to enable automatic antibot system?"})
    public static final Property<Boolean> ENABLE_ANTIBOT = PropertyInitializer.newProperty((String)"Protection.enableAntiBot", (boolean)true);
    @Comment(value={"The interval in seconds"})
    public static final Property<Integer> ANTIBOT_INTERVAL = PropertyInitializer.newProperty((String)"Protection.antiBotInterval", (int)5);
    @Comment(value={"Max number of players allowed to login in the interval", "before the AntiBot system is enabled automatically"})
    public static final Property<Integer> ANTIBOT_SENSIBILITY = PropertyInitializer.newProperty((String)"Protection.antiBotSensibility", (int)10);
    @Comment(value={"Duration in minutes of the antibot automatic system"})
    public static final Property<Integer> ANTIBOT_DURATION = PropertyInitializer.newProperty((String)"Protection.antiBotDuration", (int)10);
    @Comment(value={"Delay in seconds before the antibot activation"})
    public static final Property<Integer> ANTIBOT_DELAY = PropertyInitializer.newProperty((String)"Protection.antiBotDelay", (int)60);
    @Comment(value={"Kicks the player that issued a command before the defined time after the join process"})
    public static final Property<Integer> QUICK_COMMANDS_DENIED_BEFORE_MILLISECONDS = PropertyInitializer.newProperty((String)"Protection.quickCommands.denyCommandsBeforeMilliseconds", (int)1000);

    private ProtectionSettings() {
    }
}

