/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.properties;

import ch.jalu.configme.Comment;
import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.PropertyInitializer;
import fr.xephi.authme.output.LogLevel;

public final class PluginSettings
implements SettingsHolder {
    @Comment(value={"Do you want to enable the session feature?", "If enabled, when a player authenticates successfully,", "his IP and his nickname is saved.", "The next time the player joins the server, if his IP", "is the same as last time and the timeout hasn't", "expired, he will not need to authenticate."})
    public static final Property<Boolean> SESSIONS_ENABLED = PropertyInitializer.newProperty((String)"settings.sessions.enabled", (boolean)false);
    @Comment(value={"After how many minutes should a session expire?", "A player's session ends after the timeout or if his IP has changed"})
    public static final Property<Integer> SESSIONS_TIMEOUT = PropertyInitializer.newProperty((String)"settings.sessions.timeout", (int)10);
    @Comment(value={"Message language, available languages:", "https://github.com/AuthMe/AuthMeReloaded/blob/master/docs/translations.md"})
    public static final Property<String> MESSAGES_LANGUAGE = PropertyInitializer.newProperty((String)"settings.messagesLanguage", (String)"en");
    @Comment(value={"Enables switching a player to defined permission groups before they log in.", "See below for a detailed explanation."})
    public static final Property<Boolean> ENABLE_PERMISSION_CHECK = PropertyInitializer.newProperty((String)"GroupOptions.enablePermissionCheck", (boolean)false);
    @Comment(value={"This is a very important option: if a registered player joins the server", "AuthMe will switch him to unLoggedInGroup. This should prevent all major exploits.", "You can set up your permission plugin with this special group to have no permissions,", "or only permission to chat (or permission to send private messages etc.).", "The better way is to set up this group with few permissions, so if a player", "tries to exploit an account they can do only what you've defined for the group.", "After login, the player will be moved to his correct permissions group!", "Please note that the group name is case-sensitive, so 'admin' is different from 'Admin'", "Otherwise your group will be wiped and the player will join in the default group []!", "Example: registeredPlayerGroup: 'NotLogged'"})
    public static final Property<String> REGISTERED_GROUP = PropertyInitializer.newProperty((String)"GroupOptions.registeredPlayerGroup", (String)"");
    @Comment(value={"Similar to above, unregistered players can be set to the following", "permissions group"})
    public static final Property<String> UNREGISTERED_GROUP = PropertyInitializer.newProperty((String)"GroupOptions.unregisteredPlayerGroup", (String)"");
    @Comment(value={"Forces authme to hook into Vault instead of a specific permission handler system."})
    public static final Property<Boolean> FORCE_VAULT_HOOK = PropertyInitializer.newProperty((String)"settings.forceVaultHook", (boolean)false);
    @Comment(value={"Log level: INFO, FINE, DEBUG. Use INFO for general messages,", "FINE for some additional detailed ones (like password failed),", "and DEBUG for debugging"})
    public static final Property<LogLevel> LOG_LEVEL = PropertyInitializer.newProperty(LogLevel.class, (String)"settings.logLevel", (Enum)LogLevel.FINE);
    @Comment(value={"By default we schedule async tasks when talking to the database. If you want", "typical communication with the database to happen synchronously, set this to false"})
    public static final Property<Boolean> USE_ASYNC_TASKS = PropertyInitializer.newProperty((String)"settings.useAsyncTasks", (boolean)true);
    @Comment(value={"The name of the server, used in some placeholders."})
    public static final Property<String> SERVER_NAME = PropertyInitializer.newProperty((String)"settings.serverName", (String)"Your Minecraft Server");

    private PluginSettings() {
    }
}

