/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.properties;

import ch.jalu.configme.Comment;
import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.PropertyInitializer;
import java.util.List;

public final class EmailSettings
implements SettingsHolder {
    @Comment(value={"Email SMTP server host"})
    public static final Property<String> SMTP_HOST = PropertyInitializer.newProperty((String)"Email.mailSMTP", (String)"smtp.gmail.com");
    @Comment(value={"Email SMTP server port"})
    public static final Property<Integer> SMTP_PORT = PropertyInitializer.newProperty((String)"Email.mailPort", (int)465);
    @Comment(value={"Only affects port 25: enable TLS/STARTTLS?"})
    public static final Property<Boolean> PORT25_USE_TLS = PropertyInitializer.newProperty((String)"Email.useTls", (boolean)true);
    @Comment(value={"Email account which sends the mails"})
    public static final Property<String> MAIL_ACCOUNT = PropertyInitializer.newProperty((String)"Email.mailAccount", (String)"");
    @Comment(value={"Email account password"})
    public static final Property<String> MAIL_PASSWORD = PropertyInitializer.newProperty((String)"Email.mailPassword", (String)"");
    @Comment(value={"Email address, fill when mailAccount is not the email address of the account"})
    public static final Property<String> MAIL_ADDRESS = PropertyInitializer.newProperty((String)"Email.mailAddress", (String)"");
    @Comment(value={"Custom sender name, replacing the mailAccount name in the email"})
    public static final Property<String> MAIL_SENDER_NAME = PropertyInitializer.newProperty((String)"Email.mailSenderName", (String)"");
    @Comment(value={"Recovery password length"})
    public static final Property<Integer> RECOVERY_PASSWORD_LENGTH = PropertyInitializer.newProperty((String)"Email.RecoveryPasswordLength", (int)8);
    @Comment(value={"Mail Subject"})
    public static final Property<String> RECOVERY_MAIL_SUBJECT = PropertyInitializer.newProperty((String)"Email.mailSubject", (String)"Your new AuthMe password");
    @Comment(value={"Like maxRegPerIP but with email"})
    public static final Property<Integer> MAX_REG_PER_EMAIL = PropertyInitializer.newProperty((String)"Email.maxRegPerEmail", (int)1);
    @Comment(value={"Recall players to add an email?"})
    public static final Property<Boolean> RECALL_PLAYERS = PropertyInitializer.newProperty((String)"Email.recallPlayers", (boolean)false);
    @Comment(value={"Delay in minute for the recall scheduler"})
    public static final Property<Integer> DELAY_RECALL = PropertyInitializer.newProperty((String)"Email.delayRecall", (int)5);
    @Comment(value={"Blacklist these domains for emails"})
    public static final Property<List<String>> DOMAIN_BLACKLIST = PropertyInitializer.newListProperty((String)"Email.emailBlacklisted", (String[])new String[]{"10minutemail.com"});
    @Comment(value={"Whitelist ONLY these domains for emails"})
    public static final Property<List<String>> DOMAIN_WHITELIST = PropertyInitializer.newListProperty((String)"Email.emailWhitelisted", (String[])new String[0]);
    @Comment(value={"Send the new password drawn in an image?"})
    public static final Property<Boolean> PASSWORD_AS_IMAGE = PropertyInitializer.newProperty((String)"Email.generateImage", (boolean)false);
    @Comment(value={"The OAuth2 token"})
    public static final Property<String> OAUTH2_TOKEN = PropertyInitializer.newProperty((String)"Email.emailOauth2Token", (String)"");

    private EmailSettings() {
    }
}

