/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.properties;

import ch.jalu.configme.Comment;
import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.PropertyInitializer;
import fr.xephi.authme.datasource.DataSourceType;

public final class DatabaseSettings
implements SettingsHolder {
    @Comment(value={"What type of database do you want to use?", "Valid values: SQLITE, MARIADB, MYSQL, POSTGRESQL"})
    public static final Property<DataSourceType> BACKEND = PropertyInitializer.newProperty(DataSourceType.class, (String)"DataSource.backend", (Enum)DataSourceType.SQLITE);
    @Comment(value={"Enable the database caching system, should be disabled on bungeecord environments", "or when a website integration is being used."})
    public static final Property<Boolean> USE_CACHING = PropertyInitializer.newProperty((String)"DataSource.caching", (boolean)true);
    @Comment(value={"Database host address"})
    public static final Property<String> MYSQL_HOST = PropertyInitializer.newProperty((String)"DataSource.mySQLHost", (String)"127.0.0.1");
    @Comment(value={"Database port"})
    public static final Property<String> MYSQL_PORT = PropertyInitializer.newProperty((String)"DataSource.mySQLPort", (String)"3306");
    @Comment(value={"Connect to MySQL database over SSL"})
    public static final Property<Boolean> MYSQL_USE_SSL = PropertyInitializer.newProperty((String)"DataSource.mySQLUseSSL", (boolean)true);
    @Comment(value={"Verification of server's certificate.", "We would not recommend to set this option to false.", "Set this option to false at your own risk if and only if you know what you're doing"})
    public static final Property<Boolean> MYSQL_CHECK_SERVER_CERTIFICATE = PropertyInitializer.newProperty((String)"DataSource.mySQLCheckServerCertificate", (boolean)true);
    @Comment(value={"Authorize client to retrieve RSA server public key.", "Advanced option, ignore if you don't know what it means."})
    public static final Property<Boolean> MYSQL_ALLOW_PUBLIC_KEY_RETRIEVAL = PropertyInitializer.newProperty((String)"DataSource.mySQLAllowPublicKeyRetrieval", (boolean)true);
    @Comment(value={"Username to connect to the MySQL database"})
    public static final Property<String> MYSQL_USERNAME = PropertyInitializer.newProperty((String)"DataSource.mySQLUsername", (String)"authme");
    @Comment(value={"Password to connect to the MySQL database"})
    public static final Property<String> MYSQL_PASSWORD = PropertyInitializer.newProperty((String)"DataSource.mySQLPassword", (String)"12345");
    @Comment(value={"Database Name, use with converters or as SQLITE database name"})
    public static final Property<String> MYSQL_DATABASE = PropertyInitializer.newProperty((String)"DataSource.mySQLDatabase", (String)"authme");
    @Comment(value={"Table of the database"})
    public static final Property<String> MYSQL_TABLE = PropertyInitializer.newProperty((String)"DataSource.mySQLTablename", (String)"authme");
    @Comment(value={"Column of IDs to sort data"})
    public static final Property<String> MYSQL_COL_ID = PropertyInitializer.newProperty((String)"DataSource.mySQLColumnId", (String)"id");
    @Comment(value={"Column for storing or checking players nickname"})
    public static final Property<String> MYSQL_COL_NAME = PropertyInitializer.newProperty((String)"DataSource.mySQLColumnName", (String)"username");
    @Comment(value={"Column for storing or checking players RealName"})
    public static final Property<String> MYSQL_COL_REALNAME = PropertyInitializer.newProperty((String)"DataSource.mySQLRealName", (String)"realname");
    @Comment(value={"Column for storing players passwords"})
    public static final Property<String> MYSQL_COL_PASSWORD = PropertyInitializer.newProperty((String)"DataSource.mySQLColumnPassword", (String)"password");
    @Comment(value={"Column for storing players passwords salts"})
    public static final Property<String> MYSQL_COL_SALT = PropertyInitializer.newProperty((String)"DataSource.mySQLColumnSalt", (String)"");
    @Comment(value={"Column for storing players emails"})
    public static final Property<String> MYSQL_COL_EMAIL = PropertyInitializer.newProperty((String)"DataSource.mySQLColumnEmail", (String)"email");
    @Comment(value={"Column for storing if a player is logged in or not"})
    public static final Property<String> MYSQL_COL_ISLOGGED = PropertyInitializer.newProperty((String)"DataSource.mySQLColumnLogged", (String)"isLogged");
    @Comment(value={"Column for storing if a player has a valid session or not"})
    public static final Property<String> MYSQL_COL_HASSESSION = PropertyInitializer.newProperty((String)"DataSource.mySQLColumnHasSession", (String)"hasSession");
    @Comment(value={"Column for storing a player's TOTP key (for two-factor authentication)"})
    public static final Property<String> MYSQL_COL_TOTP_KEY = PropertyInitializer.newProperty((String)"DataSource.mySQLtotpKey", (String)"totp");
    @Comment(value={"Column for storing the player's last IP"})
    public static final Property<String> MYSQL_COL_LAST_IP = PropertyInitializer.newProperty((String)"DataSource.mySQLColumnIp", (String)"ip");
    @Comment(value={"Column for storing players lastlogins"})
    public static final Property<String> MYSQL_COL_LASTLOGIN = PropertyInitializer.newProperty((String)"DataSource.mySQLColumnLastLogin", (String)"lastlogin");
    @Comment(value={"Column storing the registration date"})
    public static final Property<String> MYSQL_COL_REGISTER_DATE = PropertyInitializer.newProperty((String)"DataSource.mySQLColumnRegisterDate", (String)"regdate");
    @Comment(value={"Column for storing the IP address at the time of registration"})
    public static final Property<String> MYSQL_COL_REGISTER_IP = PropertyInitializer.newProperty((String)"DataSource.mySQLColumnRegisterIp", (String)"regip");
    @Comment(value={"Column for storing player LastLocation - X"})
    public static final Property<String> MYSQL_COL_LASTLOC_X = PropertyInitializer.newProperty((String)"DataSource.mySQLlastlocX", (String)"x");
    @Comment(value={"Column for storing player LastLocation - Y"})
    public static final Property<String> MYSQL_COL_LASTLOC_Y = PropertyInitializer.newProperty((String)"DataSource.mySQLlastlocY", (String)"y");
    @Comment(value={"Column for storing player LastLocation - Z"})
    public static final Property<String> MYSQL_COL_LASTLOC_Z = PropertyInitializer.newProperty((String)"DataSource.mySQLlastlocZ", (String)"z");
    @Comment(value={"Column for storing player LastLocation - World Name"})
    public static final Property<String> MYSQL_COL_LASTLOC_WORLD = PropertyInitializer.newProperty((String)"DataSource.mySQLlastlocWorld", (String)"world");
    @Comment(value={"Column for storing player LastLocation - Yaw"})
    public static final Property<String> MYSQL_COL_LASTLOC_YAW = PropertyInitializer.newProperty((String)"DataSource.mySQLlastlocYaw", (String)"yaw");
    @Comment(value={"Column for storing player LastLocation - Pitch"})
    public static final Property<String> MYSQL_COL_LASTLOC_PITCH = PropertyInitializer.newProperty((String)"DataSource.mySQLlastlocPitch", (String)"pitch");
    @Comment(value={"Column for storing players uuids (optional)"})
    public static final Property<String> MYSQL_COL_PLAYER_UUID = PropertyInitializer.newProperty((String)"DataSource.mySQLPlayerUUID", (String)"");
    @Comment(value={"Column for storing players groups"})
    public static final Property<String> MYSQL_COL_GROUP = PropertyInitializer.newProperty((String)"ExternalBoardOptions.mySQLColumnGroup", (String)"");
    @Comment(value={"Overrides the size of the DB Connection Pool, default = 10"})
    public static final Property<Integer> MYSQL_POOL_SIZE = PropertyInitializer.newProperty((String)"DataSource.poolSize", (int)10);
    @Comment(value={"The maximum lifetime of a connection in the pool, default = 1800 seconds", "You should set this at least 30 seconds less than mysql server wait_timeout"})
    public static final Property<Integer> MYSQL_CONNECTION_MAX_LIFETIME = PropertyInitializer.newProperty((String)"DataSource.maxLifetime", (int)1800);

    private DatabaseSettings() {
    }
}

