/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.commandconfig;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.migration.MigrationService;
import ch.jalu.configme.resource.PropertyReader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import fr.xephi.authme.settings.SettingsMigrationService;
import fr.xephi.authme.settings.commandconfig.CommandConfig;
import fr.xephi.authme.settings.commandconfig.CommandSettingsHolder;
import fr.xephi.authme.settings.commandconfig.Executor;
import fr.xephi.authme.settings.commandconfig.OnLoginCommand;
import fr.xephi.authme.util.RandomStringUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

class CommandMigrationService
implements MigrationService {
    @VisibleForTesting
    static final List<String> COMMAND_CONFIG_PROPERTIES = ImmutableList.of((Object)"onJoin", (Object)"onLogin", (Object)"onSessionLogin", (Object)"onFirstLogin", (Object)"onRegister", (Object)"onUnregister", (Object)"onLogout");
    @Inject
    private SettingsMigrationService settingsMigrationService;

    CommandMigrationService() {
    }

    public boolean checkAndMigrate(PropertyReader reader, ConfigurationData configurationData) {
        CommandConfig commandConfig = (CommandConfig)CommandSettingsHolder.COMMANDS.determineValue(reader).getValue();
        if (this.moveOtherAccountsConfig(commandConfig) || CommandMigrationService.isAnyCommandMissing(reader)) {
            configurationData.setValue(CommandSettingsHolder.COMMANDS, (Object)commandConfig);
            return true;
        }
        return false;
    }

    private boolean moveOtherAccountsConfig(CommandConfig commandConfig) {
        if (this.settingsMigrationService.hasOldOtherAccountsCommand()) {
            OnLoginCommand command = new OnLoginCommand();
            command.setCommand(CommandMigrationService.replaceOldPlaceholdersWithNew(this.settingsMigrationService.getOldOtherAccountsCommand()));
            command.setExecutor(Executor.CONSOLE);
            command.setIfNumberOfAccountsAtLeast(Optional.of(this.settingsMigrationService.getOldOtherAccountsCommandThreshold()));
            Map<String, OnLoginCommand> onLoginCommands = commandConfig.getOnLogin();
            onLoginCommands.put(RandomStringUtils.generate(10), command);
            return true;
        }
        return false;
    }

    private static String replaceOldPlaceholdersWithNew(String oldOtherAccountsCommand) {
        return oldOtherAccountsCommand.replace("%playername%", "%p").replace("%playerip%", "%ip");
    }

    private static boolean isAnyCommandMissing(PropertyReader reader) {
        return COMMAND_CONFIG_PROPERTIES.stream().anyMatch(property -> reader.getObject(property) == null);
    }
}

