/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.commandconfig;

import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.SettingsManagerBuilder;
import ch.jalu.configme.migration.MigrationService;
import ch.jalu.configme.resource.PropertyResource;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.GeoIpService;
import fr.xephi.authme.service.yaml.YamlFileResourceProvider;
import fr.xephi.authme.settings.commandconfig.Command;
import fr.xephi.authme.settings.commandconfig.CommandConfig;
import fr.xephi.authme.settings.commandconfig.CommandMigrationService;
import fr.xephi.authme.settings.commandconfig.CommandSettingsHolder;
import fr.xephi.authme.settings.commandconfig.Executor;
import fr.xephi.authme.settings.commandconfig.OnLoginCommand;
import fr.xephi.authme.util.FileUtils;
import fr.xephi.authme.util.PlayerUtils;
import fr.xephi.authme.util.lazytags.Tag;
import fr.xephi.authme.util.lazytags.TagBuilder;
import fr.xephi.authme.util.lazytags.WrappedTagReplacer;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandManager
implements Reloadable {
    private final File dataFolder;
    private final BukkitService bukkitService;
    private final GeoIpService geoIpService;
    private final CommandMigrationService commandMigrationService;
    private final List<Tag<Player>> availableTags = this.buildAvailableTags();
    private WrappedTagReplacer<Command, Player> onJoinCommands;
    private WrappedTagReplacer<OnLoginCommand, Player> onLoginCommands;
    private WrappedTagReplacer<Command, Player> onSessionLoginCommands;
    private WrappedTagReplacer<OnLoginCommand, Player> onFirstLoginCommands;
    private WrappedTagReplacer<Command, Player> onRegisterCommands;
    private WrappedTagReplacer<Command, Player> onUnregisterCommands;
    private WrappedTagReplacer<Command, Player> onLogoutCommands;

    @Inject
    CommandManager(@DataFolder File dataFolder, BukkitService bukkitService, GeoIpService geoIpService, CommandMigrationService commandMigrationService) {
        this.dataFolder = dataFolder;
        this.bukkitService = bukkitService;
        this.geoIpService = geoIpService;
        this.commandMigrationService = commandMigrationService;
        this.reload();
    }

    public void runCommandsOnJoin(Player player) {
        this.executeCommands(player, this.onJoinCommands.getAdaptedItems(player));
    }

    public void runCommandsOnRegister(Player player) {
        this.executeCommands(player, this.onRegisterCommands.getAdaptedItems(player));
    }

    public void runCommandsOnLogin(Player player, List<String> otherAccounts) {
        int numberOfOtherAccounts = otherAccounts.size();
        this.executeCommands(player, this.onLoginCommands.getAdaptedItems(player), cmd -> CommandManager.shouldCommandBeRun(cmd, numberOfOtherAccounts));
    }

    public void runCommandsOnSessionLogin(Player player) {
        this.executeCommands(player, this.onSessionLoginCommands.getAdaptedItems(player));
    }

    public void runCommandsOnFirstLogin(Player player, List<String> otherAccounts) {
        int numberOfOtherAccounts = otherAccounts.size();
        this.executeCommands(player, this.onFirstLoginCommands.getAdaptedItems(player), cmd -> CommandManager.shouldCommandBeRun(cmd, numberOfOtherAccounts));
    }

    public void runCommandsOnUnregister(Player player) {
        this.executeCommands(player, this.onUnregisterCommands.getAdaptedItems(player));
    }

    public void runCommandsOnLogout(Player player) {
        this.executeCommands(player, this.onLogoutCommands.getAdaptedItems(player));
    }

    private void executeCommands(Player player, List<Command> commands) {
        this.executeCommands(player, commands, c -> true);
    }

    private <T extends Command> void executeCommands(Player player, List<T> commands, Predicate<T> predicate) {
        for (Command cmd : commands) {
            if (!predicate.test(cmd)) continue;
            long delay = cmd.getDelay();
            if (delay > 0L) {
                this.bukkitService.scheduleSyncDelayedTask(() -> this.dispatchCommand(player, cmd), delay);
                continue;
            }
            this.dispatchCommand(player, cmd);
        }
    }

    private void dispatchCommand(Player player, Command command) {
        if (Executor.CONSOLE.equals((Object)command.getExecutor())) {
            this.bukkitService.dispatchConsoleCommand(command.getCommand());
        } else {
            this.bukkitService.dispatchCommand((CommandSender)player, command.getCommand());
        }
    }

    private static boolean shouldCommandBeRun(OnLoginCommand command, int numberOfOtherAccounts) {
        return !(command.getIfNumberOfAccountsAtLeast().isPresent() && command.getIfNumberOfAccountsAtLeast().get() > numberOfOtherAccounts || command.getIfNumberOfAccountsLessThan().isPresent() && command.getIfNumberOfAccountsLessThan().get() <= numberOfOtherAccounts);
    }

    @Override
    public void reload() {
        File file = new File(this.dataFolder, "commands.yml");
        FileUtils.copyFileFromResource(file, "commands.yml");
        SettingsManager settingsManager = SettingsManagerBuilder.withResource((PropertyResource)YamlFileResourceProvider.loadFromFile(file)).configurationData(new Class[]{CommandSettingsHolder.class}).migrationService((MigrationService)this.commandMigrationService).create();
        CommandConfig commandConfig = (CommandConfig)settingsManager.getProperty(CommandSettingsHolder.COMMANDS);
        this.onJoinCommands = this.newReplacer(commandConfig.getOnJoin());
        this.onLoginCommands = this.newOnLoginCmdReplacer(commandConfig.getOnLogin());
        this.onFirstLoginCommands = this.newOnLoginCmdReplacer(commandConfig.getOnFirstLogin());
        this.onSessionLoginCommands = this.newReplacer(commandConfig.getOnSessionLogin());
        this.onRegisterCommands = this.newReplacer(commandConfig.getOnRegister());
        this.onUnregisterCommands = this.newReplacer(commandConfig.getOnUnregister());
        this.onLogoutCommands = this.newReplacer(commandConfig.getOnLogout());
    }

    private WrappedTagReplacer<Command, Player> newReplacer(Map<String, Command> commands) {
        return new WrappedTagReplacer<Command, Player>(this.availableTags, commands.values(), Command::getCommand, Command::copyWithCommand);
    }

    private WrappedTagReplacer<OnLoginCommand, Player> newOnLoginCmdReplacer(Map<String, OnLoginCommand> commands) {
        return new WrappedTagReplacer<OnLoginCommand, Player>(this.availableTags, commands.values(), Command::getCommand, OnLoginCommand::copyWithCommand);
    }

    private List<Tag<Player>> buildAvailableTags() {
        return Arrays.asList(TagBuilder.createTag("%p", OfflinePlayer::getName), TagBuilder.createTag("%nick", Player::getDisplayName), TagBuilder.createTag("%ip", PlayerUtils::getPlayerIp), TagBuilder.createTag("%country", pl -> this.geoIpService.getCountryName(PlayerUtils.getPlayerIp(pl))));
    }
}

