/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.auth.PlayerCache;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.CommonService;
import fr.xephi.authme.service.GeoIpService;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.util.FileUtils;
import fr.xephi.authme.util.PlayerUtils;
import fr.xephi.authme.util.lazytags.Tag;
import fr.xephi.authme.util.lazytags.TagBuilder;
import fr.xephi.authme.util.lazytags.TagReplacer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class WelcomeMessageConfiguration
implements Reloadable {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(WelcomeMessageConfiguration.class);
    @DataFolder
    @Inject
    private File pluginFolder;
    @Inject
    private Server server;
    @Inject
    private GeoIpService geoIpService;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private CommonService service;
    private final List<Tag<Player>> availableTags = Arrays.asList(TagBuilder.createTag("&", () -> String.valueOf('\u00a7')), TagBuilder.createTag("{PLAYER}", HumanEntity::getName), TagBuilder.createTag("{DISPLAYNAME}", Player::getDisplayName), TagBuilder.createTag("{DISPLAYNAMENOCOLOR}", Player::getDisplayName), TagBuilder.createTag("{ONLINE}", () -> Integer.toString(this.bukkitService.getOnlinePlayers().size())), TagBuilder.createTag("{MAXPLAYERS}", () -> Integer.toString(this.server.getMaxPlayers())), TagBuilder.createTag("{IP}", PlayerUtils::getPlayerIp), TagBuilder.createTag("{LOGINS}", () -> Integer.toString(this.playerCache.getLogged())), TagBuilder.createTag("{WORLD}", pl -> pl.getWorld().getName()), TagBuilder.createTag("{SERVER}", () -> this.service.getProperty(PluginSettings.SERVER_NAME)), TagBuilder.createTag("{VERSION}", () -> this.server.getBukkitVersion()), TagBuilder.createTag("{COUNTRY}", pl -> this.geoIpService.getCountryName(PlayerUtils.getPlayerIp(pl))));
    private TagReplacer<Player> messageSupplier;

    @Override
    @PostConstruct
    public void reload() {
        if (!this.service.getProperty(RegistrationSettings.USE_WELCOME_MESSAGE).booleanValue()) {
            return;
        }
        ArrayList<String> welcomeMessage = new ArrayList<String>();
        for (String line : this.readWelcomeFile()) {
            welcomeMessage.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        this.messageSupplier = TagReplacer.newReplacer(this.availableTags, welcomeMessage);
    }

    public List<String> getWelcomeMessage(Player player) {
        return this.messageSupplier.getAdaptedMessages(player);
    }

    public void sendWelcomeMessage(Player player) {
        if (this.service.getProperty(RegistrationSettings.USE_WELCOME_MESSAGE).booleanValue()) {
            List<String> welcomeMessage = this.getWelcomeMessage(player);
            if (this.service.getProperty(RegistrationSettings.BROADCAST_WELCOME_MESSAGE).booleanValue()) {
                welcomeMessage.forEach(this.bukkitService::broadcastMessage);
            } else {
                welcomeMessage.forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
            }
        }
    }

    private List<String> readWelcomeFile() {
        if (!this.service.getProperty(RegistrationSettings.USE_WELCOME_MESSAGE).booleanValue()) {
            return Collections.emptyList();
        }
        File welcomeFile = new File(this.pluginFolder, "welcome.txt");
        if (FileUtils.copyFileFromResource(welcomeFile, "welcome.txt")) {
            try {
                return Files.readAllLines(welcomeFile.toPath(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                this.logger.logException("Failed to read welcome.txt file:", e);
            }
        } else {
            this.logger.warning("Failed to copy welcome.txt from JAR");
        }
        return Collections.emptyList();
    }
}

