/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.service.PluginHookService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.HooksSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.util.FileUtils;
import fr.xephi.authme.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.inject.Inject;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class SpawnLoader
implements Reloadable {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(SpawnLoader.class);
    private final File authMeConfigurationFile;
    private final Settings settings;
    private final PluginHookService pluginHookService;
    private FileConfiguration authMeConfiguration;
    private String[] spawnPriority;
    private Location essentialsSpawn;
    private Location cmiSpawn;

    @Inject
    SpawnLoader(@DataFolder File pluginFolder, Settings settings, PluginHookService pluginHookService) {
        File spawnFile = new File(pluginFolder, "spawn.yml");
        FileUtils.copyFileFromResource(spawnFile, "spawn.yml");
        this.authMeConfigurationFile = spawnFile;
        this.settings = settings;
        this.pluginHookService = pluginHookService;
        this.reload();
    }

    @Override
    public void reload() {
        this.spawnPriority = ((String)this.settings.getProperty(RestrictionSettings.SPAWN_PRIORITY)).split(",");
        this.authMeConfiguration = YamlConfiguration.loadConfiguration((File)this.authMeConfigurationFile);
        this.loadEssentialsSpawn();
    }

    public Location getSpawn() {
        return SpawnLoader.getLocationFromConfiguration(this.authMeConfiguration, "spawn");
    }

    public boolean setSpawn(Location location) {
        return this.setLocation("spawn", location);
    }

    public Location getFirstSpawn() {
        return SpawnLoader.getLocationFromConfiguration(this.authMeConfiguration, "firstspawn");
    }

    public boolean setFirstSpawn(Location location) {
        return this.setLocation("firstspawn", location);
    }

    public void loadEssentialsSpawn() {
        File essentialsFolder = this.pluginHookService.getEssentialsDataFolder();
        if (essentialsFolder == null) {
            return;
        }
        File essentialsSpawnFile = new File(essentialsFolder, "spawn.yml");
        if (essentialsSpawnFile.exists()) {
            this.essentialsSpawn = SpawnLoader.getLocationFromConfiguration((FileConfiguration)YamlConfiguration.loadConfiguration((File)essentialsSpawnFile), "spawns.default");
        } else {
            this.essentialsSpawn = null;
            this.logger.info("Essentials spawn file not found: '" + essentialsSpawnFile.getAbsolutePath() + "'");
        }
    }

    public void unloadEssentialsSpawn() {
        this.essentialsSpawn = null;
    }

    public void loadCmiSpawn() {
        File cmiFolder = this.pluginHookService.getCmiDataFolder();
        if (cmiFolder == null) {
            return;
        }
        File cmiConfig = new File(cmiFolder, "config.yml");
        if (cmiConfig.exists()) {
            this.cmiSpawn = SpawnLoader.getLocationFromCmiConfiguration((FileConfiguration)YamlConfiguration.loadConfiguration((File)cmiConfig));
        } else {
            this.cmiSpawn = null;
            this.logger.info("CMI config file not found: '" + cmiConfig.getAbsolutePath() + "'");
        }
    }

    public void unloadCmiSpawn() {
        this.cmiSpawn = null;
    }

    public Location getSpawnLocation(Player player) {
        if (player == null || player.getWorld() == null) {
            return null;
        }
        World world = player.getWorld();
        Location spawnLoc = null;
        for (String priority : this.spawnPriority) {
            switch (priority.toLowerCase(Locale.ROOT).trim()) {
                case "default": {
                    if (world.getSpawnLocation() == null) break;
                    if (!this.isValidSpawnPoint(world.getSpawnLocation())) {
                        for (World spawnWorld : Bukkit.getWorlds()) {
                            if (!this.isValidSpawnPoint(spawnWorld.getSpawnLocation())) continue;
                            world = spawnWorld;
                            break;
                        }
                        this.logger.warning("Seems like AuthMe is unable to find a proper spawn location. Set a location with the command '/authme setspawn'");
                    }
                    spawnLoc = world.getSpawnLocation();
                    break;
                }
                case "multiverse": {
                    if (!((Boolean)this.settings.getProperty(HooksSettings.MULTIVERSE)).booleanValue()) break;
                    spawnLoc = this.pluginHookService.getMultiverseSpawn(world);
                    break;
                }
                case "essentials": {
                    spawnLoc = this.essentialsSpawn;
                    break;
                }
                case "cmi": {
                    spawnLoc = this.cmiSpawn;
                    break;
                }
                case "authme": {
                    spawnLoc = this.getSpawn();
                    break;
                }
            }
            if (spawnLoc == null) continue;
            this.logger.debug("Spawn location determined as `{0}` for world `{1}`", (Object)spawnLoc, (Object)world.getName());
            return spawnLoc;
        }
        this.logger.debug("Fall back to default world spawn location. World: `{0}`", (Object)world.getName());
        return world.getSpawnLocation();
    }

    private boolean isValidSpawnPoint(Location location) {
        return location.getX() != 0.0 || location.getY() != 0.0 || location.getZ() != 0.0;
    }

    private boolean setLocation(String prefix, Location location) {
        if (location != null && location.getWorld() != null) {
            this.authMeConfiguration.set(prefix + ".world", (Object)location.getWorld().getName());
            this.authMeConfiguration.set(prefix + ".x", (Object)location.getX());
            this.authMeConfiguration.set(prefix + ".y", (Object)location.getY());
            this.authMeConfiguration.set(prefix + ".z", (Object)location.getZ());
            this.authMeConfiguration.set(prefix + ".yaw", (Object)Float.valueOf(location.getYaw()));
            this.authMeConfiguration.set(prefix + ".pitch", (Object)Float.valueOf(location.getPitch()));
            return this.saveAuthMeConfig();
        }
        return false;
    }

    private boolean saveAuthMeConfig() {
        try {
            this.authMeConfiguration.save(this.authMeConfigurationFile);
            return true;
        }
        catch (IOException e) {
            this.logger.logException("Could not save spawn config (" + String.valueOf(this.authMeConfigurationFile) + ")", e);
            return false;
        }
    }

    public Location getPlayerLocationOrSpawn(Player player) {
        if (player.getHealth() <= 0.0) {
            return this.getSpawnLocation(player);
        }
        return player.getLocation();
    }

    private static Location getLocationFromConfiguration(FileConfiguration configuration, String pathPrefix) {
        if (SpawnLoader.containsAllSpawnFields(configuration, pathPrefix)) {
            String prefix = pathPrefix + ".";
            String worldName = configuration.getString(prefix + "world");
            World world = Bukkit.getWorld((String)worldName);
            if (!StringUtils.isBlank(worldName) && world != null) {
                return new Location(world, configuration.getDouble(prefix + "x"), configuration.getDouble(prefix + "y"), configuration.getDouble(prefix + "z"), SpawnLoader.getFloat(configuration, prefix + "yaw"), SpawnLoader.getFloat(configuration, prefix + "pitch"));
            }
        }
        return null;
    }

    private static Location getLocationFromCmiConfiguration(FileConfiguration configuration) {
        String pathPrefix = "Spawn.Main";
        if (SpawnLoader.isLocationCompleteInCmiConfig(configuration, "Spawn.Main")) {
            String prefix = "Spawn.Main.";
            String worldName = configuration.getString(prefix + "World");
            World world = Bukkit.getWorld((String)worldName);
            if (!StringUtils.isBlank(worldName) && world != null) {
                return new Location(world, configuration.getDouble(prefix + "X"), configuration.getDouble(prefix + "Y"), configuration.getDouble(prefix + "Z"), SpawnLoader.getFloat(configuration, prefix + "Yaw"), SpawnLoader.getFloat(configuration, prefix + "Pitch"));
            }
        }
        return null;
    }

    private static boolean containsAllSpawnFields(FileConfiguration configuration, String pathPrefix) {
        String[] fields;
        for (String field : fields = new String[]{"world", "x", "y", "z", "yaw", "pitch"}) {
            if (configuration.contains(pathPrefix + "." + field)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLocationCompleteInCmiConfig(FileConfiguration cmiConfiguration, String pathPrefix) {
        String[] fields;
        for (String field : fields = new String[]{"World", "X", "Y", "Z", "Yaw", "Pitch"}) {
            if (cmiConfiguration.contains(pathPrefix + "." + field)) continue;
            return false;
        }
        return true;
    }

    private static float getFloat(FileConfiguration configuration, String path) {
        Object value = configuration.get(path);
        return value instanceof Number ? ((Number)value).floatValue() : 0.0f;
    }
}

