/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.migration.PlainMigrationService;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.PropertyInitializer;
import ch.jalu.configme.properties.convertresult.PropertyValue;
import ch.jalu.configme.resource.PropertyReader;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.output.LogLevel;
import fr.xephi.authme.process.register.RegisterSecondaryArgument;
import fr.xephi.authme.process.register.RegistrationType;
import fr.xephi.authme.security.HashAlgorithm;
import fr.xephi.authme.security.crypts.EncryptionMethod;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class SettingsMigrationService
extends PlainMigrationService {
    private static ConsoleLogger logger = ConsoleLoggerFactory.get(SettingsMigrationService.class);
    private final File pluginFolder;
    private String oldOtherAccountsCommand;
    private int oldOtherAccountsCommandThreshold;

    @Inject
    SettingsMigrationService(@DataFolder File pluginFolder) {
        this.pluginFolder = pluginFolder;
    }

    protected boolean performMigrations(PropertyReader reader, ConfigurationData configurationData) {
        String driverClass;
        boolean changes = false;
        if ("[a-zA-Z0-9_?]*".equals(reader.getString(RestrictionSettings.ALLOWED_NICKNAME_CHARACTERS.getPath()))) {
            configurationData.setValue(RestrictionSettings.ALLOWED_NICKNAME_CHARACTERS, (Object)"[a-zA-Z0-9_]*");
            changes = true;
        }
        if ("fr.xephi.authme.libs.org.mariadb.jdbc.Driver".equals(driverClass = reader.getString("DataSource.mySQLDriverClassName"))) {
            configurationData.setValue(DatabaseSettings.BACKEND, (Object)DataSourceType.MARIADB);
            changes = true;
        }
        this.setOldOtherAccountsCommandFieldsIfSet(reader);
        return changes | this.performMailTextToFileMigration(reader) | SettingsMigrationService.migrateJoinLeaveMessages(reader, configurationData) | SettingsMigrationService.migrateForceSpawnSettings(reader, configurationData) | SettingsMigrationService.migratePoolSizeSetting(reader, configurationData) | SettingsMigrationService.changeBooleanSettingToLogLevelProperty(reader, configurationData) | SettingsMigrationService.hasOldHelpHeaderProperty(reader) | SettingsMigrationService.hasSupportOldPasswordProperty(reader) | SettingsMigrationService.convertToRegistrationType(reader, configurationData) | SettingsMigrationService.mergeAndMovePermissionGroupSettings(reader, configurationData) | SettingsMigrationService.moveDeprecatedHashAlgorithmIntoLegacySection(reader, configurationData) | SettingsMigrationService.moveSaltColumnConfigWithOtherColumnConfigs(reader, configurationData) || SettingsMigrationService.hasDeprecatedProperties(reader);
    }

    private static boolean hasDeprecatedProperties(PropertyReader reader) {
        String[] deprecatedProperties;
        for (String deprecatedPath : deprecatedProperties = new String[]{"Converter.Rakamak.newPasswordHash", "Hooks.chestshop", "Hooks.legacyChestshop", "Hooks.notifications", "Passpartu", "Performances", "settings.restrictions.enablePasswordVerifier", "Xenoforo.predefinedSalt", "VeryGames", "settings.restrictions.allowAllCommandsIfRegistrationIsOptional", "DataSource.mySQLWebsite", "Hooks.customAttributes", "Security.stop.kickPlayersBeforeStopping", "settings.restrictions.keepCollisionsDisabled", "settings.forceCommands", "settings.forceCommandsAsConsole", "settings.forceRegisterCommands", "settings.forceRegisterCommandsAsConsole", "settings.sessions.sessionExpireOnIpChange", "settings.restrictions.otherAccountsCmd", "settings.restrictions.otherAccountsCmdThreshold, DataSource.mySQLDriverClassName"}) {
            if (!reader.contains(deprecatedPath)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOldOtherAccountsCommand() {
        return !StringUtils.isBlank(this.oldOtherAccountsCommand);
    }

    public String getOldOtherAccountsCommand() {
        return this.oldOtherAccountsCommand;
    }

    public int getOldOtherAccountsCommandThreshold() {
        return this.oldOtherAccountsCommandThreshold;
    }

    private boolean performMailTextToFileMigration(PropertyReader reader) {
        String oldSettingPath = "Email.mailText";
        String oldMailText = reader.getString("Email.mailText");
        if (oldMailText == null) {
            return false;
        }
        File emailFile = new File(this.pluginFolder, "email.html");
        String mailText = oldMailText.replace("<playername>", "<playername />").replace("%playername%", "<playername />").replace("<servername>", "<servername />").replace("%servername%", "<servername />").replace("<generatedpass>", "<generatedpass />").replace("%generatedpass%", "<generatedpass />").replace("<image>", "<image />").replace("%image%", "<image />");
        if (!emailFile.exists()) {
            try (FileWriter fw = new FileWriter(emailFile);){
                fw.write(mailText);
            }
            catch (IOException e) {
                logger.logException("Could not create email.html configuration file:", e);
            }
        }
        return true;
    }

    private static boolean migrateJoinLeaveMessages(PropertyReader reader, ConfigurationData configData) {
        Property oldDelayJoinProperty = PropertyInitializer.newProperty((String)"settings.delayJoinLeaveMessages", (boolean)false);
        boolean hasMigrated = SettingsMigrationService.moveProperty(oldDelayJoinProperty, RegistrationSettings.DELAY_JOIN_MESSAGE, reader, configData);
        if (hasMigrated) {
            logger.info(String.format("Note that we now also have the settings %s and %s", RegistrationSettings.REMOVE_JOIN_MESSAGE.getPath(), RegistrationSettings.REMOVE_LEAVE_MESSAGE.getPath()));
        }
        return hasMigrated;
    }

    private static boolean migrateForceSpawnSettings(PropertyReader reader, ConfigurationData configData) {
        Property oldForceLocEnabled = PropertyInitializer.newProperty((String)"settings.restrictions.ForceSpawnLocOnJoinEnabled", (boolean)false);
        Property oldForceWorlds = PropertyInitializer.newListProperty((String)"settings.restrictions.ForceSpawnOnTheseWorlds", (String[])new String[]{"world", "world_nether", "world_the_ed"});
        return SettingsMigrationService.moveProperty(oldForceLocEnabled, RestrictionSettings.FORCE_SPAWN_LOCATION_AFTER_LOGIN, reader, configData) | SettingsMigrationService.moveProperty(oldForceWorlds, RestrictionSettings.FORCE_SPAWN_ON_WORLDS, reader, configData);
    }

    private static boolean migratePoolSizeSetting(PropertyReader reader, ConfigurationData configData) {
        Integer oldValue = reader.getInt(DatabaseSettings.MYSQL_POOL_SIZE.getPath());
        if (oldValue == null || oldValue > 0) {
            return false;
        }
        configData.setValue(DatabaseSettings.MYSQL_POOL_SIZE, (Object)10);
        return true;
    }

    private static boolean changeBooleanSettingToLogLevelProperty(PropertyReader reader, ConfigurationData configData) {
        String oldPath = "Security.console.noConsoleSpam";
        Property<LogLevel> newProperty = PluginSettings.LOG_LEVEL;
        if (!newProperty.isValidInResource(reader) && reader.contains("Security.console.noConsoleSpam")) {
            logger.info("Moving 'Security.console.noConsoleSpam' to '" + newProperty.getPath() + "'");
            boolean oldValue = Optional.ofNullable(reader.getBoolean("Security.console.noConsoleSpam")).orElse(false);
            LogLevel level = oldValue ? LogLevel.INFO : LogLevel.FINE;
            configData.setValue(newProperty, (Object)level);
            return true;
        }
        return false;
    }

    private static boolean hasOldHelpHeaderProperty(PropertyReader reader) {
        if (reader.contains("settings.helpHeader")) {
            logger.warning("Help header setting is now in messages/help_xx.yml, please check the file to set it again");
            return true;
        }
        return false;
    }

    private static boolean hasSupportOldPasswordProperty(PropertyReader reader) {
        String path = "settings.security.supportOldPasswordHash";
        if (reader.contains(path)) {
            logger.warning("Property '" + path + "' is no longer supported. Use '" + SecuritySettings.LEGACY_HASHES.getPath() + "' instead.");
            return true;
        }
        return false;
    }

    private static boolean convertToRegistrationType(PropertyReader reader, ConfigurationData configData) {
        String oldEmailRegisterPath = "settings.registration.enableEmailRegistrationSystem";
        if (RegistrationSettings.REGISTRATION_TYPE.isValidInResource(reader) || !reader.contains(oldEmailRegisterPath)) {
            return false;
        }
        boolean useEmail = (Boolean)PropertyInitializer.newProperty((String)oldEmailRegisterPath, (boolean)false).determineValue(reader).getValue();
        RegistrationType registrationType = useEmail ? RegistrationType.EMAIL : RegistrationType.PASSWORD;
        String useConfirmationPath = useEmail ? "settings.registration.doubleEmailCheck" : "settings.restrictions.enablePasswordConfirmation";
        boolean hasConfirmation = (Boolean)PropertyInitializer.newProperty((String)useConfirmationPath, (boolean)false).determineValue(reader).getValue();
        RegisterSecondaryArgument secondaryArgument = hasConfirmation ? RegisterSecondaryArgument.CONFIRMATION : RegisterSecondaryArgument.NONE;
        logger.warning("Merging old registration settings into '" + RegistrationSettings.REGISTRATION_TYPE.getPath() + "'");
        configData.setValue(RegistrationSettings.REGISTRATION_TYPE, (Object)registrationType);
        configData.setValue(RegistrationSettings.REGISTER_SECOND_ARGUMENT, (Object)secondaryArgument);
        return true;
    }

    private static boolean mergeAndMovePermissionGroupSettings(PropertyReader reader, ConfigurationData configData) {
        Property oldUnloggedInGroup = PropertyInitializer.newProperty((String)"settings.security.unLoggedinGroup", (String)"");
        Property oldRegisteredGroup = PropertyInitializer.newProperty((String)"GroupOptions.RegisteredPlayerGroup", (String)"");
        boolean performedChanges = !((String)oldUnloggedInGroup.determineValue(reader).getValue()).isEmpty() ? SettingsMigrationService.moveProperty(oldUnloggedInGroup, PluginSettings.REGISTERED_GROUP, reader, configData) : SettingsMigrationService.moveProperty(oldRegisteredGroup, PluginSettings.REGISTERED_GROUP, reader, configData);
        performedChanges |= SettingsMigrationService.moveProperty(PropertyInitializer.newProperty((String)"GroupOptions.UnregisteredPlayerGroup", (String)""), PluginSettings.UNREGISTERED_GROUP, reader, configData);
        return performedChanges |= SettingsMigrationService.moveProperty(PropertyInitializer.newProperty((String)"permission.EnablePermissionCheck", (boolean)false), PluginSettings.ENABLE_PERMISSION_CHECK, reader, configData);
    }

    private static boolean moveDeprecatedHashAlgorithmIntoLegacySection(PropertyReader reader, ConfigurationData configData) {
        Class<? extends EncryptionMethod> encryptionClass;
        HashAlgorithm currentHash = (HashAlgorithm)((Object)SecuritySettings.PASSWORD_HASH.determineValue(reader).getValue());
        if (currentHash != HashAlgorithm.CUSTOM && currentHash != HashAlgorithm.PLAINTEXT && (encryptionClass = currentHash.getClazz()).isAnnotationPresent(Deprecated.class)) {
            configData.setValue(SecuritySettings.PASSWORD_HASH, (Object)HashAlgorithm.SHA256);
            Set legacyHashes = (Set)SecuritySettings.LEGACY_HASHES.determineValue(reader).getValue();
            legacyHashes.add(currentHash);
            configData.setValue(SecuritySettings.LEGACY_HASHES, (Object)legacyHashes);
            logger.warning("The hash algorithm '" + String.valueOf((Object)currentHash) + "' is no longer supported for active use. New hashes will be in SHA256.");
            return true;
        }
        return false;
    }

    private static boolean moveSaltColumnConfigWithOtherColumnConfigs(PropertyReader reader, ConfigurationData configData) {
        Property oldProperty = PropertyInitializer.newProperty((String)"ExternalBoardOptions.mySQLColumnSalt", (String)((String)DatabaseSettings.MYSQL_COL_SALT.getDefaultValue()));
        return SettingsMigrationService.moveProperty(oldProperty, DatabaseSettings.MYSQL_COL_SALT, reader, configData);
    }

    private void setOldOtherAccountsCommandFieldsIfSet(PropertyReader reader) {
        Property commandProperty = PropertyInitializer.newProperty((String)"settings.restrictions.otherAccountsCmd", (String)"");
        Property commandThresholdProperty = PropertyInitializer.newProperty((String)"settings.restrictions.otherAccountsCmdThreshold", (int)0);
        PropertyValue commandPropValue = commandProperty.determineValue(reader);
        int commandThreshold = (Integer)commandThresholdProperty.determineValue(reader).getValue();
        if (commandPropValue.isValidInResource() && commandThreshold >= 2) {
            this.oldOtherAccountsCommand = (String)commandPropValue.getValue();
            this.oldOtherAccountsCommandThreshold = commandThreshold;
        }
    }

    protected static <T> boolean moveProperty(Property<T> oldProperty, Property<T> newProperty, PropertyReader reader, ConfigurationData configData) {
        PropertyValue oldPropertyValue = oldProperty.determineValue(reader);
        if (oldPropertyValue.isValidInResource()) {
            if (reader.contains(newProperty.getPath())) {
                logger.info("Detected deprecated property " + oldProperty.getPath());
            } else {
                logger.info("Renaming " + oldProperty.getPath() + " to " + newProperty.getPath());
                configData.setValue(newProperty, oldPropertyValue.getValue());
            }
            return true;
        }
        return false;
    }
}

