/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings;

import ch.jalu.configme.SettingsManagerImpl;
import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.migration.MigrationService;
import ch.jalu.configme.resource.PropertyResource;
import com.google.common.io.Files;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Settings
extends SettingsManagerImpl {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(Settings.class);
    private final File pluginFolder;
    private String passwordEmailMessage;
    private String verificationEmailMessage;
    private String recoveryCodeEmailMessage;

    public Settings(File pluginFolder, PropertyResource resource, MigrationService migrationService, ConfigurationData configurationData) {
        super(resource, configurationData, migrationService);
        this.pluginFolder = pluginFolder;
        this.loadSettingsFromFiles();
    }

    public String getPasswordEmailMessage() {
        return this.passwordEmailMessage;
    }

    public String getVerificationEmailMessage() {
        return this.verificationEmailMessage;
    }

    public String getRecoveryCodeEmailMessage() {
        return this.recoveryCodeEmailMessage;
    }

    private void loadSettingsFromFiles() {
        this.passwordEmailMessage = this.readFile("email.html");
        this.verificationEmailMessage = this.readFile("verification_code_email.html");
        this.recoveryCodeEmailMessage = this.readFile("recovery_code_email.html");
    }

    public void reload() {
        super.reload();
        this.loadSettingsFromFiles();
    }

    private String readFile(String filename) {
        File file = new File(this.pluginFolder, filename);
        if (FileUtils.copyFileFromResource(file, filename)) {
            try {
                return Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).read();
            }
            catch (IOException e) {
                this.logger.logException("Failed to read file '" + filename + "':", e);
            }
        } else {
            this.logger.warning("Failed to copy file '" + filename + "' from JAR");
        }
        return "";
    }
}

