/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.resource.PropertyReader;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class EnumSetProperty<E extends Enum<E>>
extends BaseProperty<Set<E>> {
    private final Class<E> enumClass;

    @SafeVarargs
    public EnumSetProperty(Class<E> enumClass, String path, E ... values) {
        super(path, (Object)Sets.newHashSet((Object[])values));
        this.enumClass = enumClass;
    }

    protected Set<E> getFromReader(PropertyReader reader, ConvertErrorRecorder errorRecorder) {
        Object entry = reader.getObject(this.getPath());
        if (entry instanceof Collection) {
            return ((Collection)entry).stream().map(val -> this.toEnum(String.valueOf(val))).filter(e -> e != null).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return null;
    }

    private E toEnum(String str) {
        for (Enum e : (Enum[])this.enumClass.getEnumConstants()) {
            if (!str.equalsIgnoreCase(e.name())) continue;
            return (E)e;
        }
        return null;
    }

    public Object toExportValue(Set<E> value) {
        return value.stream().map(Enum::name).collect(Collectors.toList());
    }
}

