/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.service.bungeecord;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.bungeecord.MessageType;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.HooksSettings;
import java.util.Locale;
import javax.inject.Inject;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;

public class BungeeSender
implements SettingsDependent {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(BungeeSender.class);
    private final AuthMe plugin;
    private final BukkitService bukkitService;
    private boolean isEnabled;
    private String destinationServerOnLogin;

    @Inject
    BungeeSender(AuthMe plugin, BukkitService bukkitService, Settings settings) {
        this.plugin = plugin;
        this.bukkitService = bukkitService;
        this.reload(settings);
    }

    @Override
    public void reload(Settings settings) {
        Messenger messenger;
        this.isEnabled = (Boolean)settings.getProperty(HooksSettings.BUNGEECORD);
        this.destinationServerOnLogin = (String)settings.getProperty(HooksSettings.BUNGEECORD_SERVER);
        if (this.isEnabled && !(messenger = this.plugin.getServer().getMessenger()).isOutgoingChannelRegistered((Plugin)this.plugin, "BungeeCord")) {
            messenger.registerOutgoingPluginChannel((Plugin)this.plugin, "BungeeCord");
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private void sendBungeecordMessage(Player player, String ... data) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        for (String element : data) {
            out.writeUTF(element);
        }
        this.bukkitService.sendBungeeMessage(player, out.toByteArray());
    }

    private void sendForwardedBungeecordMessage(Player player, String subChannel, String ... data) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Forward");
        out.writeUTF("ONLINE");
        out.writeUTF(subChannel);
        ByteArrayDataOutput dataOut = ByteStreams.newDataOutput();
        for (String element : data) {
            dataOut.writeUTF(element);
        }
        byte[] dataBytes = dataOut.toByteArray();
        out.writeShort(dataBytes.length);
        out.write(dataBytes);
        this.bukkitService.sendBungeeMessage(player, out.toByteArray());
    }

    public void connectPlayerOnLogin(Player player) {
        if (!this.isEnabled || this.destinationServerOnLogin.isEmpty()) {
            return;
        }
        this.bukkitService.scheduleSyncDelayedTask(() -> this.sendBungeecordMessage(player, "Connect", this.destinationServerOnLogin), 10L);
    }

    public void sendAuthMeBungeecordMessage(Player player, MessageType type) {
        if (!this.isEnabled) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            this.logger.debug("Tried to send a " + String.valueOf((Object)type) + " bungeecord message but the plugin was disabled!");
            return;
        }
        if (type.isBroadcast()) {
            this.sendForwardedBungeecordMessage(player, "AuthMe.v2.Broadcast", type.getId(), player.getName().toLowerCase(Locale.ROOT));
        } else {
            this.sendBungeecordMessage(player, "AuthMe.v2", type.getId(), player.getName().toLowerCase(Locale.ROOT));
        }
    }
}

