/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.service.bungeecord;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.ProxySessionManager;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.process.Management;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.bungeecord.MessageType;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.HooksSettings;
import java.util.Optional;
import javax.inject.Inject;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BungeeReceiver
implements PluginMessageListener,
SettingsDependent {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(BungeeReceiver.class);
    private final AuthMe plugin;
    private final BukkitService bukkitService;
    private final ProxySessionManager proxySessionManager;
    private final Management management;
    private boolean isEnabled;

    @Inject
    BungeeReceiver(AuthMe plugin, BukkitService bukkitService, ProxySessionManager proxySessionManager, Management management, Settings settings) {
        this.plugin = plugin;
        this.bukkitService = bukkitService;
        this.proxySessionManager = proxySessionManager;
        this.management = management;
        this.reload(settings);
    }

    @Override
    public void reload(Settings settings) {
        Messenger messenger;
        this.isEnabled = (Boolean)settings.getProperty(HooksSettings.BUNGEECORD);
        if (this.isEnabled) {
            this.isEnabled = this.bukkitService.isBungeeCordConfiguredForSpigot().orElse(false);
        }
        if (this.isEnabled && !(messenger = this.plugin.getServer().getMessenger()).isIncomingChannelRegistered((Plugin)this.plugin, "BungeeCord")) {
            messenger.registerIncomingPluginChannel((Plugin)this.plugin, "BungeeCord", (PluginMessageListener)this);
        }
    }

    private void handleBroadcast(ByteArrayDataInput in) {
        short dataLength = in.readShort();
        byte[] dataBytes = new byte[dataLength];
        in.readFully(dataBytes);
        ByteArrayDataInput dataIn = ByteStreams.newDataInput((byte[])dataBytes);
        String typeId = dataIn.readUTF();
        Optional<MessageType> type = MessageType.fromId(typeId);
        if (!type.isPresent()) {
            this.logger.debug("Received unsupported forwarded bungeecord message type! ({0})", (Object)typeId);
            return;
        }
        try {
            String argument = dataIn.readUTF();
        }
        catch (IllegalStateException e) {
            this.logger.warning("Received invalid forwarded plugin message of type " + type.get().name() + ": argument is missing!");
            return;
        }
        switch (type.get()) {
            case LOGIN: 
            case LOGOUT: {
                break;
            }
        }
    }

    private void handle(ByteArrayDataInput in) {
        String argument;
        String typeId = in.readUTF();
        Optional<MessageType> type = MessageType.fromId(typeId);
        if (!type.isPresent()) {
            this.logger.debug("Received unsupported bungeecord message type! ({0})", (Object)typeId);
            return;
        }
        try {
            argument = in.readUTF();
        }
        catch (IllegalStateException e) {
            this.logger.warning("Received invalid plugin message of type " + type.get().name() + ": argument is missing!");
            return;
        }
        switch (type.get()) {
            case PERFORM_LOGIN: {
                this.performLogin(argument);
                break;
            }
        }
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] data) {
        if (!this.isEnabled) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        String subChannel = in.readUTF();
        if ("AuthMe.v2.Broadcast".equals(subChannel)) {
            this.handleBroadcast(in);
        } else if ("AuthMe.v2".equals(subChannel)) {
            this.handle(in);
        }
    }

    private void performLogin(String name) {
        Player player = this.bukkitService.getPlayerExact(name);
        if (player != null && player.isOnline()) {
            this.management.forceLogin(player, true);
            this.logger.info("The user " + player.getName() + " has been automatically logged in, as requested via plugin messaging.");
        } else {
            this.proxySessionManager.processProxySessionMessage(name);
            this.logger.info("The user " + name + " should be automatically logged in, as requested via plugin messaging but has not been detected, nickname has been added to autologin queue.");
        }
    }
}

