/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.service;

import ch.jalu.configme.properties.Property;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.service.GeoIpService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.ProtectionSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.PlayerUtils;
import fr.xephi.authme.util.StringUtils;
import fr.xephi.authme.util.Utils;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ValidationService
implements Reloadable {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(ValidationService.class);
    @Inject
    private Settings settings;
    @Inject
    private DataSource dataSource;
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private GeoIpService geoIpService;
    private Pattern passwordRegex;
    private Multimap<String, String> restrictedNames;

    ValidationService() {
    }

    @Override
    @PostConstruct
    public void reload() {
        this.passwordRegex = Utils.safePatternCompile((String)this.settings.getProperty(RestrictionSettings.ALLOWED_PASSWORD_REGEX));
        this.restrictedNames = (Boolean)this.settings.getProperty(RestrictionSettings.ENABLE_RESTRICTED_USERS) != false ? this.loadNameRestrictions((Set)this.settings.getProperty(RestrictionSettings.RESTRICTED_USERS)) : HashMultimap.create();
    }

    public ValidationResult validatePassword(String password, String username) {
        String passLow = password.toLowerCase(Locale.ROOT);
        if (!this.passwordRegex.matcher(passLow).matches()) {
            return new ValidationResult(MessageKey.PASSWORD_CHARACTERS_ERROR, this.passwordRegex.pattern());
        }
        if (passLow.equalsIgnoreCase(username)) {
            return new ValidationResult(MessageKey.PASSWORD_IS_USERNAME_ERROR, new String[0]);
        }
        if (password.length() < (Integer)this.settings.getProperty(SecuritySettings.MIN_PASSWORD_LENGTH) || password.length() > (Integer)this.settings.getProperty(SecuritySettings.MAX_PASSWORD_LENGTH)) {
            return new ValidationResult(MessageKey.INVALID_PASSWORD_LENGTH, new String[0]);
        }
        if (((Set)this.settings.getProperty(SecuritySettings.UNSAFE_PASSWORDS)).contains(passLow)) {
            return new ValidationResult(MessageKey.PASSWORD_UNSAFE_ERROR, new String[0]);
        }
        return new ValidationResult();
    }

    public boolean validateEmail(String email) {
        if (Utils.isEmailEmpty(email) || !StringUtils.isInsideString('@', email)) {
            return false;
        }
        String emailDomain = email.split("@")[1];
        return this.validateWhitelistAndBlacklist(emailDomain, EmailSettings.DOMAIN_WHITELIST, EmailSettings.DOMAIN_BLACKLIST);
    }

    public boolean isEmailFreeForRegistration(String email, CommandSender sender) {
        return this.permissionsManager.hasPermission(sender, PlayerStatePermission.ALLOW_MULTIPLE_ACCOUNTS) || this.dataSource.countAuthsByEmail(email) < (Integer)this.settings.getProperty(EmailSettings.MAX_REG_PER_EMAIL);
    }

    public boolean isCountryAdmitted(String hostAddress) {
        if (((List)this.settings.getProperty(ProtectionSettings.COUNTRIES_WHITELIST)).isEmpty() && ((List)this.settings.getProperty(ProtectionSettings.COUNTRIES_BLACKLIST)).isEmpty()) {
            return true;
        }
        String countryCode = this.geoIpService.getCountryCode(hostAddress);
        boolean isCountryAllowed = this.validateWhitelistAndBlacklist(countryCode, ProtectionSettings.COUNTRIES_WHITELIST, ProtectionSettings.COUNTRIES_BLACKLIST);
        this.logger.debug("Country code `{0}` for `{1}` is allowed: {2}", countryCode, hostAddress, isCountryAllowed);
        return isCountryAllowed;
    }

    public boolean isUnrestricted(String name) {
        return ((Set)this.settings.getProperty(RestrictionSettings.UNRESTRICTED_NAMES)).contains(name.toLowerCase(Locale.ROOT));
    }

    public boolean fulfillsNameRestrictions(Player player) {
        Collection restrictions = this.restrictedNames.get((Object)player.getName().toLowerCase(Locale.ROOT));
        if (Utils.isCollectionEmpty(restrictions)) {
            return true;
        }
        String ip = PlayerUtils.getPlayerIp(player);
        String domain = this.getHostName(player.getAddress());
        for (String restriction : restrictions) {
            restriction = restriction.startsWith("regex:") ? restriction.replace("regex:", "") : restriction.replace("*", "(.*)");
            if (ip.matches(restriction)) {
                return true;
            }
            if (!domain.matches(restriction)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected String getHostName(InetSocketAddress inetSocketAddr) {
        return inetSocketAddr.getHostName();
    }

    private boolean validateWhitelistAndBlacklist(String value, Property<List<String>> whitelist, Property<List<String>> blacklist) {
        List whitelistValue = (List)this.settings.getProperty(whitelist);
        if (!Utils.isCollectionEmpty(whitelistValue)) {
            return ValidationService.containsIgnoreCase(whitelistValue, value);
        }
        List blacklistValue = (List)this.settings.getProperty(blacklist);
        return Utils.isCollectionEmpty(blacklistValue) || !ValidationService.containsIgnoreCase(blacklistValue, value);
    }

    private static boolean containsIgnoreCase(Collection<String> coll, String needle) {
        for (String entry : coll) {
            if (!entry.equalsIgnoreCase(needle)) continue;
            return true;
        }
        return false;
    }

    private Multimap<String, String> loadNameRestrictions(Set<String> configuredRestrictions) {
        HashMultimap restrictions = HashMultimap.create();
        for (String restriction : configuredRestrictions) {
            if (StringUtils.isInsideString(';', restriction)) {
                String[] data = restriction.split(";");
                restrictions.put((Object)data[0].toLowerCase(Locale.ROOT), (Object)data[1]);
                continue;
            }
            this.logger.warning("Restricted user rule must have a ';' separating name from restriction, but found: '" + restriction + "'");
        }
        return restrictions;
    }

    public static final class ValidationResult {
        private final MessageKey messageKey;
        private final String[] args;

        public ValidationResult() {
            this.messageKey = null;
            this.args = null;
        }

        public ValidationResult(MessageKey messageKey, String ... args) {
            this.messageKey = messageKey;
            this.args = args;
        }

        public boolean hasError() {
            return this.messageKey != null;
        }

        public MessageKey getMessageKey() {
            return this.messageKey;
        }

        public String[] getArgs() {
            return this.args;
        }
    }
}

