/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.service;

import ch.jalu.injector.annotations.NoFieldScan;
import com.earth2me.essentials.Essentials;
import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import java.io.File;
import javax.inject.Inject;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

@NoFieldScan
public class PluginHookService {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(PluginHookService.class);
    private final PluginManager pluginManager;
    private Essentials essentials;
    private Plugin cmi;
    private MultiverseCore multiverse;

    @Inject
    public PluginHookService(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        this.tryHookToEssentials();
        this.tryHookToCmi();
        this.tryHookToMultiverse();
    }

    public void setEssentialsSocialSpyStatus(Player player, boolean socialSpyStatus) {
        if (this.essentials != null) {
            this.essentials.getUser(player).setSocialSpyEnabled(socialSpyStatus);
        }
    }

    public File getEssentialsDataFolder() {
        if (this.essentials != null) {
            return this.essentials.getDataFolder();
        }
        return null;
    }

    public File getCmiDataFolder() {
        Plugin plugin = this.pluginManager.getPlugin("CMI");
        if (plugin == null) {
            return null;
        }
        return plugin.getDataFolder();
    }

    public Location getMultiverseSpawn(World world) {
        MVWorldManager manager;
        if (this.multiverse != null && (manager = this.multiverse.getMVWorldManager()).isMVWorld(world)) {
            return manager.getMVWorld(world).getSpawnLocation();
        }
        return null;
    }

    public boolean isEssentialsAvailable() {
        return this.essentials != null;
    }

    public boolean isCmiAvailable() {
        return this.cmi != null;
    }

    public boolean isMultiverseAvailable() {
        return this.multiverse != null;
    }

    public void tryHookToEssentials() {
        try {
            this.essentials = this.getPlugin(this.pluginManager, "Essentials", Essentials.class);
        }
        catch (Exception | NoClassDefFoundError ignored) {
            this.essentials = null;
        }
    }

    public void tryHookToCmi() {
        try {
            this.cmi = this.getPlugin(this.pluginManager, "CMI", Plugin.class);
        }
        catch (Exception | NoClassDefFoundError ignored) {
            this.cmi = null;
        }
    }

    public void tryHookToMultiverse() {
        try {
            this.multiverse = this.getPlugin(this.pluginManager, "Multiverse-Core", MultiverseCore.class);
        }
        catch (Exception | NoClassDefFoundError ignored) {
            this.multiverse = null;
        }
    }

    public void unhookEssentials() {
        this.essentials = null;
    }

    public void unhookCmi() {
        this.cmi = null;
    }

    public void unhookMultiverse() {
        this.multiverse = null;
    }

    private <T extends Plugin> T getPlugin(PluginManager pluginManager, String name, Class<T> clazz) throws Exception, NoClassDefFoundError {
        if (pluginManager.isPluginEnabled(name)) {
            Plugin plugin = (Plugin)clazz.cast(pluginManager.getPlugin(name));
            this.logger.info("Hooked successfully into " + name);
            return (T)plugin;
        }
        return null;
    }
}

