/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.service;

import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;

public class JoinMessageService {
    private BukkitService bukkitService;
    private Map<String, String> joinMessages;

    @Inject
    JoinMessageService(BukkitService bukkitService) {
        this.bukkitService = bukkitService;
        this.joinMessages = new ConcurrentHashMap<String, String>();
    }

    public void putMessage(String playerName, String string) {
        this.joinMessages.put(playerName, string);
    }

    public void sendMessage(String playerName) {
        String joinMessage = this.joinMessages.remove(playerName);
        if (!StringUtils.isBlank(joinMessage)) {
            this.bukkitService.broadcastMessage(joinMessage);
        }
    }
}

