/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.service;

import com.google.common.collect.ImmutableMap;
import fr.xephi.authme.command.CommandArgumentDescription;
import fr.xephi.authme.command.CommandDescription;
import fr.xephi.authme.command.CommandInitializer;
import fr.xephi.authme.command.help.HelpMessage;
import fr.xephi.authme.command.help.HelpMessagesService;
import fr.xephi.authme.command.help.HelpSection;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.message.MessagePathHelper;
import fr.xephi.authme.permission.DefaultPermission;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class HelpTranslationGenerator {
    @Inject
    private CommandInitializer commandInitializer;
    @Inject
    private HelpMessagesService helpMessagesService;
    @Inject
    private Settings settings;
    @DataFolder
    @Inject
    private File dataFolder;

    public File updateHelpFile() throws IOException {
        String languageCode = (String)this.settings.getProperty(PluginSettings.MESSAGES_LANGUAGE);
        File helpFile = new File(this.dataFolder, MessagePathHelper.createHelpMessageFilePath(languageCode));
        Map<String, Object> helpEntries = this.generateHelpMessageEntries();
        String helpEntriesYaml = HelpTranslationGenerator.exportToYaml(helpEntries);
        Files.write(helpFile.toPath(), helpEntriesYaml.getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
        return helpFile;
    }

    private static String exportToYaml(Map<String, Object> helpEntries) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setAllowUnicode(true);
        return new Yaml(options).dump(helpEntries);
    }

    private Map<String, Object> generateHelpMessageEntries() {
        LinkedHashMap<String, Object> messageEntries = new LinkedHashMap<String, Object>(HelpMessage.values().length);
        for (HelpMessage message : HelpMessage.values()) {
            messageEntries.put(message.getEntryKey(), this.helpMessagesService.getMessage(message));
        }
        LinkedHashMap<String, String> defaultPermissions = new LinkedHashMap<String, String>();
        for (DefaultPermission defaultPermission : DefaultPermission.values()) {
            defaultPermissions.put(HelpMessagesService.getDefaultPermissionsSubPath(defaultPermission), this.helpMessagesService.getMessage(defaultPermission));
        }
        messageEntries.put("defaultPermissions", defaultPermissions);
        LinkedHashMap<String, String> sectionEntries = new LinkedHashMap<String, String>(HelpSection.values().length);
        for (HelpSection section : HelpSection.values()) {
            sectionEntries.put(section.getEntryKey(), this.helpMessagesService.getMessage(section));
        }
        LinkedHashMap<String, Object> commandEntries = new LinkedHashMap<String, Object>();
        for (CommandDescription command : this.commandInitializer.getCommands()) {
            this.generateCommandEntries(command, commandEntries);
        }
        return ImmutableMap.of((Object)"common", messageEntries, (Object)"section", sectionEntries, (Object)"commands", commandEntries);
    }

    private void generateCommandEntries(CommandDescription command, Map<String, Object> commandEntries) {
        CommandDescription translatedCommand = this.helpMessagesService.buildLocalizedDescription(command);
        LinkedHashMap<Object, Object> commandData = new LinkedHashMap<Object, Object>();
        commandData.put("description", translatedCommand.getDescription());
        commandData.put("detailedDescription", translatedCommand.getDetailedDescription());
        int i = 1;
        for (CommandArgumentDescription argument : translatedCommand.getArguments()) {
            LinkedHashMap<String, String> argumentData = new LinkedHashMap<String, String>(2);
            argumentData.put("label", argument.getName());
            argumentData.put("description", argument.getDescription());
            commandData.put("arg" + i, argumentData);
            ++i;
        }
        commandEntries.put(HelpMessagesService.getCommandSubPath(translatedCommand), commandData);
        translatedCommand.getChildren().forEach(child -> this.generateCommandEntries((CommandDescription)child, commandEntries));
    }
}

