/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.service;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BukkitService
implements SettingsDependent {
    public static final int TICKS_PER_SECOND = 20;
    public static final int TICKS_PER_MINUTE = 1200;
    private final AuthMe authMe;
    private boolean useAsyncTasks;

    @Inject
    BukkitService(AuthMe authMe, Settings settings) {
        this.authMe = authMe;
        this.reload(settings);
    }

    public int scheduleSyncDelayedTask(Runnable task) {
        return Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.authMe, task);
    }

    public int scheduleSyncDelayedTask(Runnable task, long delay) {
        return Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.authMe, task, delay);
    }

    public void scheduleSyncTaskFromOptionallyAsyncTask(Runnable task) {
        if (Bukkit.isPrimaryThread()) {
            task.run();
        } else {
            this.scheduleSyncDelayedTask(task);
        }
    }

    public BukkitTask runTask(Runnable task) {
        return Bukkit.getScheduler().runTask((Plugin)this.authMe, task);
    }

    public BukkitTask runTaskLater(Runnable task, long delay) {
        return Bukkit.getScheduler().runTaskLater((Plugin)this.authMe, task, delay);
    }

    public void runTaskOptionallyAsync(Runnable task) {
        if (this.useAsyncTasks) {
            this.runTaskAsynchronously(task);
        } else {
            task.run();
        }
    }

    public BukkitTask runTaskAsynchronously(Runnable task) {
        return Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.authMe, task);
    }

    public BukkitTask runTaskTimerAsynchronously(BukkitRunnable task, long delay, long period) {
        return task.runTaskTimerAsynchronously((Plugin)this.authMe, delay, period);
    }

    public BukkitTask runTaskTimer(BukkitRunnable task, long delay, long period) {
        return task.runTaskTimer((Plugin)this.authMe, delay, period);
    }

    public int broadcastMessage(String message) {
        return Bukkit.broadcastMessage((String)message);
    }

    public Player getPlayerExact(String name) {
        return this.authMe.getServer().getPlayerExact(name);
    }

    public OfflinePlayer getOfflinePlayer(String name) {
        return this.authMe.getServer().getOfflinePlayer(name);
    }

    public Set<OfflinePlayer> getBannedPlayers() {
        return Bukkit.getBannedPlayers();
    }

    public OfflinePlayer[] getOfflinePlayers() {
        return Bukkit.getOfflinePlayers();
    }

    public Collection<Player> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers();
    }

    public void callEvent(Event event) {
        Bukkit.getPluginManager().callEvent(event);
    }

    public <E extends Event> E createAndCallEvent(Function<Boolean, E> eventSupplier) {
        Event event = (Event)eventSupplier.apply(this.useAsyncTasks);
        this.callEvent(event);
        return (E)event;
    }

    public World getWorld(String name) {
        return Bukkit.getWorld((String)name);
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        return Bukkit.dispatchCommand((CommandSender)sender, (String)commandLine);
    }

    public boolean dispatchConsoleCommand(String commandLine) {
        return Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)commandLine);
    }

    @Override
    public void reload(Settings settings) {
        this.useAsyncTasks = (Boolean)settings.getProperty(PluginSettings.USE_ASYNC_TASKS);
    }

    public void sendBungeeMessage(Player player, byte[] bytes) {
        player.sendPluginMessage((Plugin)this.authMe, "BungeeCord", bytes);
    }

    public BanEntry banIp(String ip, String reason, Date expires, String source) {
        return Bukkit.getServer().getBanList(BanList.Type.IP).addBan(ip, reason, expires, source);
    }

    public Optional<Boolean> isBungeeCordConfiguredForSpigot() {
        try {
            YamlConfiguration spigotConfig = Bukkit.spigot().getConfig();
            return Optional.of(spigotConfig.getBoolean("settings.bungeecord"));
        }
        catch (NoSuchMethodError e) {
            return Optional.empty();
        }
    }

    public PotionEffect createBlindnessEffect(int timeoutInTicks) {
        return new PotionEffect(PotionEffectType.BLINDNESS, timeoutInTicks, 2);
    }

    public String getIp() {
        return Bukkit.getServer().getIp();
    }
}

