/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.service;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.mail.EmailService;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.BackupSettings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import fr.xephi.authme.util.FileUtils;
import fr.xephi.authme.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;

public class BackupService {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(EmailService.class);
    private final File dataFolder;
    private final File backupFolder;
    private final Settings settings;

    @Inject
    public BackupService(@DataFolder File dataFolder, Settings settings) {
        this.dataFolder = dataFolder;
        this.backupFolder = new File(dataFolder, "backups");
        this.settings = settings;
    }

    public void doBackup(BackupCause cause) {
        this.doBackup(cause, null);
    }

    public void doBackup(BackupCause cause, CommandSender sender) {
        if (!((Boolean)this.settings.getProperty(BackupSettings.ENABLED)).booleanValue()) {
            if (cause == BackupCause.COMMAND || cause == BackupCause.OTHER) {
                Utils.logAndSendWarning(sender, "Can't perform a backup: disabled in configuration. Cause of the backup: " + cause.name());
            }
            return;
        }
        if (BackupCause.START == cause && !((Boolean)this.settings.getProperty(BackupSettings.ON_SERVER_START)).booleanValue() || BackupCause.STOP == cause && !((Boolean)this.settings.getProperty(BackupSettings.ON_SERVER_STOP)).booleanValue()) {
            return;
        }
        if (this.doBackup()) {
            Utils.logAndSendMessage(sender, "A backup has been performed successfully. Cause of the backup: " + cause.name());
        } else {
            Utils.logAndSendWarning(sender, "Error while performing a backup! Cause of the backup: " + cause.name());
        }
    }

    private boolean doBackup() {
        DataSourceType dataSourceType = (DataSourceType)((Object)this.settings.getProperty(DatabaseSettings.BACKEND));
        switch (dataSourceType) {
            case MYSQL: {
                return this.performMySqlBackup();
            }
            case SQLITE: {
                String dbName = (String)this.settings.getProperty(DatabaseSettings.MYSQL_DATABASE);
                return this.performFileBackup(dbName + ".db");
            }
        }
        this.logger.warning("Unknown data source type '" + String.valueOf((Object)dataSourceType) + "' for backup");
        return false;
    }

    private boolean performMySqlBackup() {
        FileUtils.createDirectory(this.backupFolder);
        File sqlBackupFile = this.constructBackupFile("sql");
        String backupWindowsPath = (String)this.settings.getProperty(BackupSettings.MYSQL_WINDOWS_PATH);
        boolean isUsingWindows = this.useWindowsCommand(backupWindowsPath);
        String backupCommand = isUsingWindows ? backupWindowsPath + "\\bin\\mysqldump.exe" + this.buildMysqlDumpArguments(sqlBackupFile) : "mysqldump" + this.buildMysqlDumpArguments(sqlBackupFile);
        try {
            Process runtimeProcess = Runtime.getRuntime().exec(backupCommand);
            int processComplete = runtimeProcess.waitFor();
            if (processComplete == 0) {
                this.logger.info("Backup created successfully. (Using Windows = " + isUsingWindows + ")");
                return true;
            }
            this.logger.warning("Could not create the backup! (Using Windows = " + isUsingWindows + ")");
        }
        catch (IOException | InterruptedException e) {
            this.logger.logException("Error during backup (using Windows = " + isUsingWindows + "):", e);
        }
        return false;
    }

    private boolean performFileBackup(String filename) {
        FileUtils.createDirectory(this.backupFolder);
        File backupFile = this.constructBackupFile("db");
        try {
            BackupService.copy(new File(this.dataFolder, filename), backupFile);
            return true;
        }
        catch (IOException ex) {
            this.logger.logException("Encountered an error during file backup:", ex);
            return false;
        }
    }

    private boolean useWindowsCommand(String windowsPath) {
        String isWin = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (isWin.contains("win")) {
            if (new File(windowsPath + "\\bin\\mysqldump.exe").exists()) {
                return true;
            }
            this.logger.warning("Mysql Windows Path is incorrect. Please check it");
            return false;
        }
        return false;
    }

    private String buildMysqlDumpArguments(File sqlBackupFile) {
        String dbUsername = (String)this.settings.getProperty(DatabaseSettings.MYSQL_USERNAME);
        String dbPassword = (String)this.settings.getProperty(DatabaseSettings.MYSQL_PASSWORD);
        String dbName = (String)this.settings.getProperty(DatabaseSettings.MYSQL_DATABASE);
        String tableName = (String)this.settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        return " -u " + dbUsername + " -p" + dbPassword + " " + dbName + " --tables " + tableName + " -r " + sqlBackupFile.getPath() + ".sql";
    }

    private File constructBackupFile(String fileExtension) {
        String dateString = FileUtils.createCurrentTimeString();
        return new File(this.backupFolder, "backup" + dateString + "." + fileExtension);
    }

    private static void copy(File src, File dst) throws IOException {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dst);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
    }

    public static enum BackupCause {
        START,
        STOP,
        COMMAND,
        OTHER;

    }
}

