/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.service;

import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.message.Messages;
import fr.xephi.authme.permission.AdminPermission;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.ProtectionSettings;
import fr.xephi.authme.util.AtomicIntervalCounter;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.scheduler.BukkitTask;

public class AntiBotService
implements SettingsDependent {
    private final Messages messages;
    private final PermissionsManager permissionsManager;
    private final BukkitService bukkitService;
    private final CopyOnWriteArrayList<String> antibotKicked = new CopyOnWriteArrayList();
    private int duration;
    private AntiBotStatus antiBotStatus;
    private boolean startup;
    private BukkitTask disableTask;
    private AtomicIntervalCounter flaggedCounter;

    @Inject
    AntiBotService(Settings settings, Messages messages, PermissionsManager permissionsManager, BukkitService bukkitService) {
        this.messages = messages;
        this.permissionsManager = permissionsManager;
        this.bukkitService = bukkitService;
        this.disableTask = null;
        this.antiBotStatus = AntiBotStatus.DISABLED;
        this.startup = true;
        this.reload(settings);
    }

    @Override
    public void reload(Settings settings) {
        this.duration = (Integer)settings.getProperty(ProtectionSettings.ANTIBOT_DURATION);
        int sensibility = (Integer)settings.getProperty(ProtectionSettings.ANTIBOT_SENSIBILITY);
        int interval = (Integer)settings.getProperty(ProtectionSettings.ANTIBOT_INTERVAL);
        this.flaggedCounter = new AtomicIntervalCounter(sensibility, interval * 1000);
        this.stopProtection();
        this.antiBotStatus = AntiBotStatus.DISABLED;
        if (!((Boolean)settings.getProperty(ProtectionSettings.ENABLE_ANTIBOT)).booleanValue()) {
            return;
        }
        Runnable enableTask = () -> {
            this.antiBotStatus = AntiBotStatus.LISTENING;
        };
        if (this.startup) {
            int delay = (Integer)settings.getProperty(ProtectionSettings.ANTIBOT_DELAY);
            this.bukkitService.scheduleSyncDelayedTask(enableTask, delay * 20);
            this.startup = false;
        } else {
            enableTask.run();
        }
    }

    private void startProtection() {
        if (this.antiBotStatus == AntiBotStatus.ACTIVE) {
            return;
        }
        if (this.disableTask != null) {
            this.disableTask.cancel();
        }
        this.disableTask = this.bukkitService.runTaskLater(this::stopProtection, this.duration * 1200);
        this.antiBotStatus = AntiBotStatus.ACTIVE;
        this.bukkitService.scheduleSyncTaskFromOptionallyAsyncTask(() -> this.bukkitService.getOnlinePlayers().stream().filter(player -> this.permissionsManager.hasPermission((CommandSender)player, AdminPermission.ANTIBOT_MESSAGES)).forEach(player -> this.messages.send((CommandSender)player, MessageKey.ANTIBOT_AUTO_ENABLED_MESSAGE)));
    }

    private void stopProtection() {
        if (this.antiBotStatus != AntiBotStatus.ACTIVE) {
            return;
        }
        this.antiBotStatus = AntiBotStatus.LISTENING;
        this.flaggedCounter.reset();
        this.antibotKicked.clear();
        this.disableTask.cancel();
        this.disableTask = null;
        String durationString = Integer.toString(this.duration);
        this.bukkitService.getOnlinePlayers().stream().filter(player -> this.permissionsManager.hasPermission((CommandSender)player, AdminPermission.ANTIBOT_MESSAGES)).forEach(player -> this.messages.send((CommandSender)player, MessageKey.ANTIBOT_AUTO_DISABLED_MESSAGE, durationString));
    }

    public AntiBotStatus getAntiBotStatus() {
        return this.antiBotStatus;
    }

    public void overrideAntiBotStatus(boolean started) {
        if (this.antiBotStatus != AntiBotStatus.DISABLED) {
            if (started) {
                this.startProtection();
            } else {
                this.stopProtection();
            }
        }
    }

    public boolean shouldKick() {
        if (this.antiBotStatus == AntiBotStatus.DISABLED) {
            return false;
        }
        if (this.antiBotStatus == AntiBotStatus.ACTIVE) {
            return true;
        }
        if (this.flaggedCounter.handle()) {
            this.startProtection();
            return true;
        }
        return false;
    }

    public boolean wasPlayerKicked(String name) {
        return this.antibotKicked.contains(name.toLowerCase(Locale.ROOT));
    }

    public void addPlayerKick(String name) {
        this.antibotKicked.addIfAbsent(name.toLowerCase(Locale.ROOT));
    }

    public static enum AntiBotStatus {
        LISTENING,
        DISABLED,
        ACTIVE;

    }
}

