/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.totp;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.Ints;
import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import com.warrenstrange.googleauth.GoogleAuthenticatorQRGenerator;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.initialization.HasCleanup;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import java.util.Locale;
import javax.inject.Inject;
import org.bukkit.entity.Player;

public class TotpAuthenticator
implements HasCleanup {
    private static final int CODE_RETENTION_MINUTES = 5;
    private final IGoogleAuthenticator authenticator;
    private final Settings settings;
    private final Table<String, Integer, Long> usedCodes = HashBasedTable.create();

    @Inject
    TotpAuthenticator(Settings settings) {
        this.authenticator = this.createGoogleAuthenticator();
        this.settings = settings;
    }

    protected IGoogleAuthenticator createGoogleAuthenticator() {
        return new GoogleAuthenticator();
    }

    public boolean checkCode(PlayerAuth auth, String totpCode) {
        return this.checkCode(auth.getNickname(), auth.getTotpKey(), totpCode);
    }

    public boolean checkCode(String playerName, String totpKey, String inputCode) {
        String nameLower = playerName.toLowerCase(Locale.ROOT);
        Integer totpCode = Ints.tryParse((String)inputCode);
        if (totpCode != null && !this.usedCodes.contains((Object)nameLower, (Object)totpCode) && this.authenticator.authorize(totpKey, totpCode.intValue())) {
            this.usedCodes.put((Object)nameLower, (Object)totpCode, (Object)System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public TotpGenerationResult generateTotpKey(Player player) {
        GoogleAuthenticatorKey credentials = this.authenticator.createCredentials();
        String qrCodeUrl = GoogleAuthenticatorQRGenerator.getOtpAuthURL((String)((String)this.settings.getProperty(PluginSettings.SERVER_NAME)), (String)player.getName(), (GoogleAuthenticatorKey)credentials);
        return new TotpGenerationResult(credentials.getKey(), qrCodeUrl);
    }

    @Override
    public void performCleanup() {
        long threshold = System.currentTimeMillis() - 300000L;
        this.usedCodes.values().removeIf(value -> value < threshold);
    }

    public static final class TotpGenerationResult {
        private final String totpKey;
        private final String authenticatorQrCodeUrl;

        public TotpGenerationResult(String totpKey, String authenticatorQrCodeUrl) {
            this.totpKey = totpKey;
            this.authenticatorQrCodeUrl = authenticatorQrCodeUrl;
        }

        public String getTotpKey() {
            return this.totpKey;
        }

        public String getAuthenticatorQrCodeUrl() {
            return this.authenticatorQrCodeUrl;
        }
    }
}

