/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.totp;

import fr.xephi.authme.initialization.HasCleanup;
import fr.xephi.authme.security.totp.TotpAuthenticator;
import fr.xephi.authme.util.expiring.ExpiringMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.bukkit.entity.Player;

public class GenerateTotpService
implements HasCleanup {
    private static final int NEW_TOTP_KEY_EXPIRATION_MINUTES = 5;
    private final ExpiringMap<String, TotpAuthenticator.TotpGenerationResult> totpKeys = new ExpiringMap(5L, TimeUnit.MINUTES);
    @Inject
    private TotpAuthenticator totpAuthenticator;

    GenerateTotpService() {
    }

    public TotpAuthenticator.TotpGenerationResult generateTotpKey(Player player) {
        TotpAuthenticator.TotpGenerationResult credentials = this.totpAuthenticator.generateTotpKey(player);
        this.totpKeys.put(player.getName().toLowerCase(Locale.ROOT), credentials);
        return credentials;
    }

    public TotpAuthenticator.TotpGenerationResult getGeneratedTotpKey(Player player) {
        return this.totpKeys.get(player.getName().toLowerCase(Locale.ROOT));
    }

    public void removeGenerateTotpKey(Player player) {
        this.totpKeys.remove(player.getName().toLowerCase(Locale.ROOT));
    }

    public boolean isTotpCodeCorrectForGeneratedTotpKey(Player player, String totpCode) {
        TotpAuthenticator.TotpGenerationResult totpDetails = this.totpKeys.get(player.getName().toLowerCase(Locale.ROOT));
        return totpDetails != null && this.totpAuthenticator.checkCode(player.getName(), totpDetails.getTotpKey(), totpCode);
    }

    @Override
    public void performCleanup() {
        this.totpKeys.removeExpiredEntries();
    }
}

