/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import fr.xephi.authme.security.HashUtils;
import fr.xephi.authme.security.crypts.EncryptionMethod;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.security.crypts.description.HasSalt;
import fr.xephi.authme.security.crypts.description.Recommendation;
import fr.xephi.authme.security.crypts.description.SaltType;
import fr.xephi.authme.security.crypts.description.Usage;
import fr.xephi.authme.util.RandomStringUtils;
import java.util.Locale;

@Recommendation(value=Usage.DO_NOT_USE)
@HasSalt(value=SaltType.USERNAME)
public class Smf
implements EncryptionMethod {
    @Override
    public HashedPassword computeHash(String password, String name) {
        return new HashedPassword(this.computeHash(password, null, name), this.generateSalt());
    }

    @Override
    public String computeHash(String password, String salt, String name) {
        return HashUtils.sha1(name.toLowerCase(Locale.ROOT) + password);
    }

    @Override
    public boolean comparePassword(String password, HashedPassword hashedPassword, String name) {
        return HashUtils.isEqual(hashedPassword.getHash(), this.computeHash(password, null, name));
    }

    @Override
    public String generateSalt() {
        return RandomStringUtils.generate(4);
    }

    @Override
    public boolean hasSeparateSalt() {
        return true;
    }
}

