/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import fr.xephi.authme.security.HashUtils;
import fr.xephi.authme.security.crypts.EncryptionMethod;
import fr.xephi.authme.security.crypts.HashedPassword;

public abstract class SeparateSaltMethod
implements EncryptionMethod {
    @Override
    public abstract String computeHash(String var1, String var2, String var3);

    @Override
    public HashedPassword computeHash(String password, String name) {
        String salt = this.generateSalt();
        return new HashedPassword(this.computeHash(password, salt, name), salt);
    }

    @Override
    public abstract String generateSalt();

    @Override
    public boolean comparePassword(String password, HashedPassword hashedPassword, String name) {
        return HashUtils.isEqual(hashedPassword.getHash(), this.computeHash(password, hashedPassword.getSalt(), null));
    }

    @Override
    public boolean hasSeparateSalt() {
        return true;
    }
}

