/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import fr.xephi.authme.security.HashUtils;
import fr.xephi.authme.security.crypts.SeparateSaltMethod;
import fr.xephi.authme.security.crypts.description.HasSalt;
import fr.xephi.authme.security.crypts.description.Recommendation;
import fr.xephi.authme.security.crypts.description.SaltType;
import fr.xephi.authme.security.crypts.description.Usage;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.RandomStringUtils;
import javax.inject.Inject;

@Recommendation(value=Usage.ACCEPTABLE)
@HasSalt(value=SaltType.TEXT)
public class Salted2Md5
extends SeparateSaltMethod {
    private final int saltLength;

    @Inject
    public Salted2Md5(Settings settings) {
        this.saltLength = (Integer)settings.getProperty(SecuritySettings.DOUBLE_MD5_SALT_LENGTH);
    }

    @Override
    public String computeHash(String password, String salt, String name) {
        return HashUtils.md5(HashUtils.md5(password) + salt);
    }

    @Override
    public String generateSalt() {
        return RandomStringUtils.generateHex(this.saltLength);
    }
}

