/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import fr.xephi.authme.security.crypts.EncryptionMethod;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.security.crypts.description.HasSalt;
import fr.xephi.authme.security.crypts.description.Recommendation;
import fr.xephi.authme.security.crypts.description.SaltType;
import fr.xephi.authme.security.crypts.description.Usage;
import fr.xephi.authme.util.RandomStringUtils;

@Recommendation(value=Usage.ACCEPTABLE)
@HasSalt(value=SaltType.TEXT)
public abstract class HexSaltedMethod
implements EncryptionMethod {
    public abstract int getSaltLength();

    @Override
    public abstract String computeHash(String var1, String var2, String var3);

    @Override
    public HashedPassword computeHash(String password, String name) {
        String salt = this.generateSalt();
        return new HashedPassword(this.computeHash(password, salt, null));
    }

    @Override
    public abstract boolean comparePassword(String var1, HashedPassword var2, String var3);

    @Override
    public String generateSalt() {
        return RandomStringUtils.generateHex(this.getSaltLength());
    }

    @Override
    public boolean hasSeparateSalt() {
        return false;
    }
}

