/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import fr.xephi.authme.security.crypts.BCryptHasher;
import fr.xephi.authme.security.crypts.EncryptionMethod;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.security.crypts.description.HasSalt;
import fr.xephi.authme.security.crypts.description.Recommendation;
import fr.xephi.authme.security.crypts.description.SaltType;
import fr.xephi.authme.security.crypts.description.Usage;
import java.nio.charset.StandardCharsets;

@Recommendation(value=Usage.RECOMMENDED)
@HasSalt(value=SaltType.TEXT, length=22)
public abstract class BCryptBasedHash
implements EncryptionMethod {
    private final BCryptHasher bCryptHasher;

    public BCryptBasedHash(BCryptHasher bCryptHasher) {
        this.bCryptHasher = bCryptHasher;
    }

    @Override
    public HashedPassword computeHash(String password, String name) {
        return this.bCryptHasher.hash(password);
    }

    @Override
    public String computeHash(String password, String salt, String name) {
        return this.bCryptHasher.hashWithRawSalt(password, salt.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean comparePassword(String password, HashedPassword hashedPassword, String name) {
        return BCryptHasher.comparePassword(password, hashedPassword.getHash());
    }

    @Override
    public String generateSalt() {
        return BCryptHasher.generateSalt();
    }

    @Override
    public boolean hasSeparateSalt() {
        return false;
    }
}

