/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import de.mkammerer.argon2.Argon2Factory;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.security.crypts.UnsaltedMethod;
import fr.xephi.authme.security.crypts.description.HasSalt;
import fr.xephi.authme.security.crypts.description.Recommendation;
import fr.xephi.authme.security.crypts.description.SaltType;
import fr.xephi.authme.security.crypts.description.Usage;

@Recommendation(value=Usage.RECOMMENDED)
@HasSalt(value=SaltType.TEXT, length=16)
public class Argon2
extends UnsaltedMethod {
    private static ConsoleLogger logger = ConsoleLoggerFactory.get(Argon2.class);
    private de.mkammerer.argon2.Argon2 argon2 = Argon2Factory.create();

    public static boolean isLibraryLoaded() {
        try {
            System.loadLibrary("argon2");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            logger.logException("Cannot find argon2 library: https://github.com/AuthMe/AuthMeReloaded/wiki/Argon2-as-Password-Hash", e);
            return false;
        }
    }

    @Override
    public String computeHash(String password) {
        return this.argon2.hash(2, 65536, 1, password);
    }

    @Override
    public boolean comparePassword(String password, HashedPassword hashedPassword, String name) {
        return this.argon2.verify(hashedPassword.getHash(), password);
    }
}

