/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security;

import ch.jalu.injector.factory.Factory;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.events.PasswordEncryptionEvent;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.security.HashAlgorithm;
import fr.xephi.authme.security.crypts.EncryptionMethod;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;

public class PasswordSecurity
implements Reloadable {
    @Inject
    private Settings settings;
    @Inject
    private DataSource dataSource;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private Factory<EncryptionMethod> encryptionMethodFactory;
    private EncryptionMethod encryptionMethod;
    private Collection<HashAlgorithm> legacyAlgorithms;

    @Override
    @PostConstruct
    public void reload() {
        HashAlgorithm algorithm = (HashAlgorithm)((Object)this.settings.getProperty(SecuritySettings.PASSWORD_HASH));
        this.encryptionMethod = this.initializeEncryptionMethodWithEvent(algorithm);
        this.legacyAlgorithms = (Collection)this.settings.getProperty(SecuritySettings.LEGACY_HASHES);
    }

    public HashedPassword computeHash(String password, String playerName) {
        String playerLowerCase = playerName.toLowerCase(Locale.ROOT);
        return this.encryptionMethod.computeHash(password, playerLowerCase);
    }

    public boolean comparePassword(String password, String playerName) {
        HashedPassword auth = this.dataSource.getPassword(playerName);
        return auth != null && this.comparePassword(password, auth, playerName);
    }

    public boolean comparePassword(String password, HashedPassword hashedPassword, String playerName) {
        String playerLowerCase = playerName.toLowerCase(Locale.ROOT);
        return PasswordSecurity.methodMatches(this.encryptionMethod, password, hashedPassword, playerLowerCase) || this.compareWithLegacyHashes(password, hashedPassword, playerLowerCase);
    }

    private boolean compareWithLegacyHashes(String password, HashedPassword hashedPassword, String playerName) {
        for (HashAlgorithm algorithm : this.legacyAlgorithms) {
            EncryptionMethod method = this.initializeEncryptionMethod(algorithm);
            if (!PasswordSecurity.methodMatches(method, password, hashedPassword, playerName)) continue;
            this.hashAndSavePasswordWithNewAlgorithm(password, playerName);
            return true;
        }
        return false;
    }

    private static boolean methodMatches(EncryptionMethod method, String password, HashedPassword hashedPassword, String playerName) {
        return method != null && (!method.hasSeparateSalt() || hashedPassword.getSalt() != null) && method.comparePassword(password, hashedPassword, playerName);
    }

    private EncryptionMethod initializeEncryptionMethodWithEvent(HashAlgorithm algorithm) {
        EncryptionMethod method = this.initializeEncryptionMethod(algorithm);
        PasswordEncryptionEvent event = new PasswordEncryptionEvent(method);
        this.pluginManager.callEvent((Event)event);
        return event.getMethod();
    }

    private EncryptionMethod initializeEncryptionMethod(HashAlgorithm algorithm) {
        if (HashAlgorithm.CUSTOM.equals((Object)algorithm) || HashAlgorithm.PLAINTEXT.equals((Object)algorithm)) {
            return null;
        }
        return (EncryptionMethod)this.encryptionMethodFactory.newInstance(algorithm.getClazz());
    }

    private void hashAndSavePasswordWithNewAlgorithm(String password, String playerName) {
        HashedPassword hashedPassword = this.encryptionMethod.computeHash(password, playerName);
        this.dataSource.updatePassword(playerName, hashedPassword);
    }
}

