/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.register.executors;

import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.process.register.executors.AbstractPasswordRegisterExecutor;
import fr.xephi.authme.process.register.executors.PlayerAuthBuilderHelper;
import fr.xephi.authme.process.register.executors.TwoFactorRegisterParams;
import fr.xephi.authme.security.crypts.TwoFactor;
import fr.xephi.authme.service.CommonService;
import javax.inject.Inject;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

class TwoFactorRegisterExecutor
extends AbstractPasswordRegisterExecutor<TwoFactorRegisterParams> {
    @Inject
    private CommonService commonService;

    TwoFactorRegisterExecutor() {
    }

    @Override
    public boolean isRegistrationAdmitted(TwoFactorRegisterParams params) {
        return true;
    }

    @Override
    protected PlayerAuth createPlayerAuthObject(TwoFactorRegisterParams params) {
        return PlayerAuthBuilderHelper.createPlayerAuth(params.getPlayer(), params.getHashedPassword(), null);
    }

    @Override
    public void executePostPersistAction(TwoFactorRegisterParams params) {
        super.executePostPersistAction(params);
        String hash = params.getHashedPassword().getHash();
        String qrCodeUrl = TwoFactor.getQrBarcodeUrl(params.getPlayerName(), Bukkit.getIp(), hash);
        this.commonService.send((CommandSender)params.getPlayer(), MessageKey.TWO_FACTOR_CREATE, hash, qrCodeUrl);
    }
}

