/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.register.executors;

import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.mail.EmailService;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.process.SyncProcessManager;
import fr.xephi.authme.process.register.executors.EmailRegisterParams;
import fr.xephi.authme.process.register.executors.PlayerAuthBuilderHelper;
import fr.xephi.authme.process.register.executors.RegistrationExecutor;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.service.CommonService;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.util.RandomStringUtils;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class EmailRegisterExecutor
implements RegistrationExecutor<EmailRegisterParams> {
    @Inject
    private DataSource dataSource;
    @Inject
    private CommonService commonService;
    @Inject
    private EmailService emailService;
    @Inject
    private SyncProcessManager syncProcessManager;
    @Inject
    private PasswordSecurity passwordSecurity;

    EmailRegisterExecutor() {
    }

    @Override
    public boolean isRegistrationAdmitted(EmailRegisterParams params) {
        int otherAccounts;
        int maxRegPerEmail = this.commonService.getProperty(EmailSettings.MAX_REG_PER_EMAIL);
        if (maxRegPerEmail > 0 && !this.commonService.hasPermission(params.getPlayer(), PlayerStatePermission.ALLOW_MULTIPLE_ACCOUNTS) && (otherAccounts = this.dataSource.countAuthsByEmail(params.getEmail())) >= maxRegPerEmail) {
            this.commonService.send((CommandSender)params.getPlayer(), MessageKey.MAX_REGISTER_EXCEEDED, Integer.toString(maxRegPerEmail), Integer.toString(otherAccounts), "@");
            return false;
        }
        return true;
    }

    @Override
    public PlayerAuth buildPlayerAuth(EmailRegisterParams params) {
        String password = RandomStringUtils.generate(this.commonService.getProperty(EmailSettings.RECOVERY_PASSWORD_LENGTH));
        HashedPassword hashedPassword = this.passwordSecurity.computeHash(password, params.getPlayer().getName());
        params.setPassword(password);
        return PlayerAuthBuilderHelper.createPlayerAuth(params.getPlayer(), hashedPassword, params.getEmail());
    }

    @Override
    public void executePostPersistAction(EmailRegisterParams params) {
        Player player = params.getPlayer();
        boolean couldSendMail = this.emailService.sendPasswordMail(player.getName(), params.getEmail(), params.getPassword());
        if (couldSendMail) {
            this.syncProcessManager.processSyncEmailRegister(player);
        } else {
            this.commonService.send((CommandSender)player, MessageKey.EMAIL_SEND_FAILURE);
        }
    }
}

