/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.register.executors;

import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.process.SyncProcessManager;
import fr.xephi.authme.process.login.AsynchronousLogin;
import fr.xephi.authme.process.register.executors.AbstractPasswordRegisterParams;
import fr.xephi.authme.process.register.executors.RegistrationExecutor;
import fr.xephi.authme.process.register.executors.RegistrationParameters;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.CommonService;
import fr.xephi.authme.service.ValidationService;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

abstract class AbstractPasswordRegisterExecutor<P extends AbstractPasswordRegisterParams>
implements RegistrationExecutor<P> {
    private static final int SYNC_LOGIN_DELAY = 5;
    @Inject
    private ValidationService validationService;
    @Inject
    private CommonService commonService;
    @Inject
    private PasswordSecurity passwordSecurity;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private SyncProcessManager syncProcessManager;
    @Inject
    private AsynchronousLogin asynchronousLogin;

    AbstractPasswordRegisterExecutor() {
    }

    @Override
    public boolean isRegistrationAdmitted(P params) {
        ValidationService.ValidationResult passwordValidation = this.validationService.validatePassword(((AbstractPasswordRegisterParams)params).getPassword(), ((RegistrationParameters)params).getPlayer().getName());
        if (passwordValidation.hasError()) {
            this.commonService.send((CommandSender)((RegistrationParameters)params).getPlayer(), passwordValidation.getMessageKey(), passwordValidation.getArgs());
            return false;
        }
        return true;
    }

    @Override
    public PlayerAuth buildPlayerAuth(P params) {
        HashedPassword hashedPassword = this.passwordSecurity.computeHash(((AbstractPasswordRegisterParams)params).getPassword(), ((RegistrationParameters)params).getPlayerName());
        ((AbstractPasswordRegisterParams)params).setHashedPassword(hashedPassword);
        return this.createPlayerAuthObject(params);
    }

    protected abstract PlayerAuth createPlayerAuthObject(P var1);

    protected boolean performLoginAfterRegister(P params) {
        return this.commonService.getProperty(RegistrationSettings.FORCE_LOGIN_AFTER_REGISTER) == false;
    }

    @Override
    public void executePostPersistAction(P params) {
        Player player = ((RegistrationParameters)params).getPlayer();
        if (this.performLoginAfterRegister(params)) {
            if (this.commonService.getProperty(PluginSettings.USE_ASYNC_TASKS).booleanValue()) {
                this.bukkitService.runTaskAsynchronously(() -> this.asynchronousLogin.forceLogin(player));
            } else {
                this.bukkitService.scheduleSyncDelayedTask(() -> this.asynchronousLogin.forceLogin(player), 5L);
            }
        }
        this.syncProcessManager.processSyncPasswordRegister(player);
    }
}

