/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.register;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.limbo.LimboService;
import fr.xephi.authme.events.RegisterEvent;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.process.SynchronousProcess;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.CommonService;
import fr.xephi.authme.service.bungeecord.BungeeSender;
import fr.xephi.authme.settings.commandconfig.CommandManager;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.util.PlayerUtils;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ProcessSyncPasswordRegister
implements SynchronousProcess {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(ProcessSyncPasswordRegister.class);
    @Inject
    private BungeeSender bungeeSender;
    @Inject
    private CommonService service;
    @Inject
    private LimboService limboService;
    @Inject
    private CommandManager commandManager;
    @Inject
    private BukkitService bukkitService;

    ProcessSyncPasswordRegister() {
    }

    private void requestLogin(Player player) {
        this.limboService.replaceTasksAfterRegistration(player);
        if (player.isInsideVehicle() && player.getVehicle() != null) {
            player.getVehicle().eject();
        }
    }

    public void processPasswordRegister(Player player) {
        this.service.send((CommandSender)player, MessageKey.REGISTER_SUCCESS);
        if (!this.service.getProperty(EmailSettings.MAIL_ACCOUNT).isEmpty()) {
            this.service.send((CommandSender)player, MessageKey.ADD_EMAIL_MESSAGE);
        }
        this.bukkitService.callEvent(new RegisterEvent(player));
        this.logger.fine(player.getName() + " registered " + PlayerUtils.getPlayerIp(player));
        if (this.service.getProperty(RegistrationSettings.FORCE_KICK_AFTER_REGISTER).booleanValue()) {
            player.kickPlayer(this.service.retrieveSingleMessage((CommandSender)player, MessageKey.REGISTER_SUCCESS));
            return;
        }
        this.commandManager.runCommandsOnRegister(player);
        if (this.service.getProperty(RegistrationSettings.FORCE_LOGIN_AFTER_REGISTER).booleanValue()) {
            this.requestLogin(player);
            return;
        }
        this.bungeeSender.connectPlayerOnLogin(player);
    }
}

