/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.register;

import ch.jalu.injector.factory.SingletonStore;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.data.auth.PlayerCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.events.AuthMeAsyncPreRegisterEvent;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.process.AsynchronousProcess;
import fr.xephi.authme.process.register.executors.RegistrationExecutor;
import fr.xephi.authme.process.register.executors.RegistrationMethod;
import fr.xephi.authme.process.register.executors.RegistrationParameters;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.CommonService;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.util.InternetProtocolUtils;
import fr.xephi.authme.util.PlayerUtils;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AsyncRegister
implements AsynchronousProcess {
    @Inject
    private DataSource database;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private CommonService service;
    @Inject
    private SingletonStore<RegistrationExecutor> registrationExecutorFactory;

    AsyncRegister() {
    }

    public <P extends RegistrationParameters> void register(RegistrationMethod<P> variant, P parameters) {
        RegistrationExecutor executor;
        if (this.preRegisterCheck(variant, parameters.getPlayer()) && (executor = (RegistrationExecutor)this.registrationExecutorFactory.getSingleton(variant.getExecutorClass())).isRegistrationAdmitted(parameters)) {
            this.executeRegistration(parameters, executor);
        }
    }

    private boolean preRegisterCheck(RegistrationMethod<?> variant, Player player) {
        String name = player.getName().toLowerCase(Locale.ROOT);
        if (this.playerCache.isAuthenticated(name)) {
            this.service.send((CommandSender)player, MessageKey.ALREADY_LOGGED_IN_ERROR);
            return false;
        }
        if (!this.service.getProperty(RegistrationSettings.IS_ENABLED).booleanValue()) {
            this.service.send((CommandSender)player, MessageKey.REGISTRATION_DISABLED);
            return false;
        }
        if (this.database.isAuthAvailable(name)) {
            this.service.send((CommandSender)player, MessageKey.NAME_ALREADY_REGISTERED);
            return false;
        }
        AuthMeAsyncPreRegisterEvent event = this.bukkitService.createAndCallEvent(isAsync -> new AuthMeAsyncPreRegisterEvent(player, (boolean)isAsync));
        if (!event.canRegister()) {
            return false;
        }
        return variant == RegistrationMethod.API_REGISTRATION || this.isPlayerIpAllowedToRegister(player);
    }

    private <P extends RegistrationParameters> void executeRegistration(P parameters, RegistrationExecutor<P> executor) {
        PlayerAuth auth = executor.buildPlayerAuth(parameters);
        if (this.database.saveAuth(auth)) {
            executor.executePostPersistAction(parameters);
        } else {
            this.service.send((CommandSender)parameters.getPlayer(), MessageKey.ERROR);
        }
    }

    private boolean isPlayerIpAllowedToRegister(Player player) {
        List<String> otherAccounts;
        int maxRegPerIp = this.service.getProperty(RestrictionSettings.MAX_REGISTRATION_PER_IP);
        String ip = PlayerUtils.getPlayerIp(player);
        if (maxRegPerIp > 0 && !InternetProtocolUtils.isLoopbackAddress(ip) && !this.service.hasPermission(player, PlayerStatePermission.ALLOW_MULTIPLE_ACCOUNTS) && (otherAccounts = this.database.getAllAuthsByIp(ip)).size() >= maxRegPerIp) {
            this.service.send((CommandSender)player, MessageKey.MAX_REGISTER_EXCEEDED, Integer.toString(maxRegPerIp), Integer.toString(otherAccounts.size()), String.join((CharSequence)", ", otherAccounts));
            return false;
        }
        return true;
    }
}

