/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.login;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.TempbanManager;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.data.auth.PlayerCache;
import fr.xephi.authme.data.captcha.LoginCaptchaManager;
import fr.xephi.authme.data.limbo.LimboMessageType;
import fr.xephi.authme.data.limbo.LimboPlayerState;
import fr.xephi.authme.data.limbo.LimboService;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.events.AuthMeAsyncPreLoginEvent;
import fr.xephi.authme.events.FailedLoginEvent;
import fr.xephi.authme.mail.EmailService;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.permission.AdminPermission;
import fr.xephi.authme.permission.PlayerPermission;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.process.AsynchronousProcess;
import fr.xephi.authme.process.SyncProcessManager;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.CommonService;
import fr.xephi.authme.service.SessionService;
import fr.xephi.authme.service.bungeecord.BungeeSender;
import fr.xephi.authme.service.bungeecord.MessageType;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.HooksSettings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.util.InternetProtocolUtils;
import fr.xephi.authme.util.PlayerUtils;
import fr.xephi.authme.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AsynchronousLogin
implements AsynchronousProcess {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(AsynchronousLogin.class);
    @Inject
    private DataSource dataSource;
    @Inject
    private CommonService service;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private SyncProcessManager syncProcessManager;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private PasswordSecurity passwordSecurity;
    @Inject
    private LoginCaptchaManager loginCaptchaManager;
    @Inject
    private TempbanManager tempbanManager;
    @Inject
    private LimboService limboService;
    @Inject
    private EmailService emailService;
    @Inject
    private SessionService sessionService;
    @Inject
    private BungeeSender bungeeSender;

    AsynchronousLogin() {
    }

    public void login(Player player, String password) {
        PlayerAuth auth = this.getPlayerAuth(player);
        if (auth != null && this.checkPlayerInfo(player, auth, password)) {
            if (auth.getTotpKey() != null) {
                this.limboService.resetMessageTask(player, LimboMessageType.TOTP_CODE);
                this.limboService.getLimboPlayer(player.getName()).setState(LimboPlayerState.TOTP_REQUIRED);
            } else {
                this.performLogin(player, auth);
            }
        }
    }

    public void forceLogin(Player player) {
        PlayerAuth auth = this.getPlayerAuth(player);
        if (auth != null) {
            this.performLogin(player, auth);
        }
    }

    public void forceLogin(Player player, boolean quiet) {
        PlayerAuth auth = this.getPlayerAuth(player, quiet);
        if (auth != null) {
            this.performLogin(player, auth);
        }
    }

    private PlayerAuth getPlayerAuth(Player player) {
        return this.getPlayerAuth(player, false);
    }

    private PlayerAuth getPlayerAuth(Player player, boolean quiet) {
        String name = player.getName().toLowerCase(Locale.ROOT);
        if (this.playerCache.isAuthenticated(name)) {
            if (!quiet) {
                this.service.send((CommandSender)player, MessageKey.ALREADY_LOGGED_IN_ERROR);
            }
            return null;
        }
        PlayerAuth auth = this.dataSource.getAuth(name);
        if (auth == null) {
            if (!quiet) {
                this.service.send((CommandSender)player, MessageKey.UNKNOWN_USER);
            }
            this.limboService.resetMessageTask(player, LimboMessageType.REGISTER);
            return null;
        }
        if (!this.service.getProperty(DatabaseSettings.MYSQL_COL_GROUP).isEmpty() && auth.getGroupId() == this.service.getProperty(HooksSettings.NON_ACTIVATED_USERS_GROUP).intValue()) {
            if (!quiet) {
                this.service.send((CommandSender)player, MessageKey.ACCOUNT_NOT_ACTIVATED);
            }
            return null;
        }
        String ip = PlayerUtils.getPlayerIp(player);
        if (this.hasReachedMaxLoggedInPlayersForIp(player, ip)) {
            if (!quiet) {
                this.service.send((CommandSender)player, MessageKey.ALREADY_LOGGED_IN_ERROR);
            }
            return null;
        }
        boolean isAsync = this.service.getProperty(PluginSettings.USE_ASYNC_TASKS);
        AuthMeAsyncPreLoginEvent event = new AuthMeAsyncPreLoginEvent(player, isAsync);
        this.bukkitService.callEvent(event);
        if (!event.canLogin()) {
            return null;
        }
        return auth;
    }

    private boolean checkPlayerInfo(Player player, PlayerAuth auth, String password) {
        String name = player.getName().toLowerCase(Locale.ROOT);
        if (this.loginCaptchaManager.isCaptchaRequired(name)) {
            this.service.send((CommandSender)player, MessageKey.USAGE_CAPTCHA, this.loginCaptchaManager.getCaptchaCodeOrGenerateNew(name));
            return false;
        }
        String ip = PlayerUtils.getPlayerIp(player);
        this.loginCaptchaManager.increaseLoginFailureCount(name);
        this.tempbanManager.increaseCount(ip, name);
        if (this.passwordSecurity.comparePassword(password, auth.getPassword(), player.getName())) {
            return true;
        }
        this.handleWrongPassword(player, auth, ip);
        return false;
    }

    private void handleWrongPassword(Player player, PlayerAuth auth, String ip) {
        this.logger.fine(player.getName() + " used the wrong password");
        this.bukkitService.createAndCallEvent(isAsync -> new FailedLoginEvent(player, (boolean)isAsync));
        if (this.tempbanManager.shouldTempban(ip)) {
            this.tempbanManager.tempbanPlayer(player);
        } else if (this.service.getProperty(RestrictionSettings.KICK_ON_WRONG_PASSWORD).booleanValue()) {
            this.bukkitService.scheduleSyncTaskFromOptionallyAsyncTask(() -> player.kickPlayer(this.service.retrieveSingleMessage((CommandSender)player, MessageKey.WRONG_PASSWORD)));
        } else {
            this.service.send((CommandSender)player, MessageKey.WRONG_PASSWORD);
            if (this.loginCaptchaManager.isCaptchaRequired(player.getName())) {
                this.limboService.muteMessageTask(player);
                this.service.send((CommandSender)player, MessageKey.USAGE_CAPTCHA, this.loginCaptchaManager.getCaptchaCodeOrGenerateNew(player.getName()));
            } else if (this.emailService.hasAllInformation() && !Utils.isEmailEmpty(auth.getEmail())) {
                this.service.send((CommandSender)player, MessageKey.FORGOT_PASSWORD_MESSAGE);
            }
        }
    }

    public void performLogin(Player player, PlayerAuth auth) {
        if (player.isOnline()) {
            boolean isFirstLogin = auth.getLastLogin() == null;
            String ip = PlayerUtils.getPlayerIp(player);
            auth.setRealName(player.getName());
            auth.setLastLogin(System.currentTimeMillis());
            auth.setLastIp(ip);
            this.dataSource.updateSession(auth);
            String name = player.getName();
            this.loginCaptchaManager.resetLoginFailureCount(name);
            this.tempbanManager.resetCount(ip, name);
            player.setNoDamageTicks(0);
            this.service.send((CommandSender)player, MessageKey.LOGIN_SUCCESS);
            List<String> auths = this.dataSource.getAllAuthsByIp(auth.getLastIp());
            this.displayOtherAccounts(auths, player);
            String email = auth.getEmail();
            if (this.service.getProperty(EmailSettings.RECALL_PLAYERS).booleanValue() && Utils.isEmailEmpty(email)) {
                this.service.send((CommandSender)player, MessageKey.ADD_EMAIL_MESSAGE);
            }
            this.logger.fine(player.getName() + " logged in " + ip);
            this.playerCache.updatePlayer(auth);
            this.dataSource.setLogged(name);
            this.sessionService.grantSession(name);
            if (this.bungeeSender.isEnabled()) {
                this.bukkitService.scheduleSyncDelayedTask(() -> this.bungeeSender.sendAuthMeBungeecordMessage(player, MessageType.LOGIN), 5L);
            }
            this.syncProcessManager.processSyncPlayerLogin(player, isFirstLogin, auths);
        } else {
            this.logger.warning("Player '" + player.getName() + "' wasn't online during login process, aborted...");
        }
    }

    private void displayOtherAccounts(List<String> auths, Player player) {
        if (!this.service.getProperty(RestrictionSettings.DISPLAY_OTHER_ACCOUNTS).booleanValue() || auths.size() <= 1) {
            return;
        }
        ArrayList<Object> formattedNames = new ArrayList<Object>(auths.size());
        for (String currentName : auths) {
            Player currentPlayer = this.bukkitService.getPlayerExact(currentName);
            if (currentPlayer != null && currentPlayer.isOnline()) {
                formattedNames.add(String.valueOf(ChatColor.GREEN) + currentPlayer.getName() + String.valueOf(ChatColor.GRAY));
                continue;
            }
            formattedNames.add(currentName);
        }
        String message = String.valueOf(ChatColor.GRAY) + String.join((CharSequence)", ", formattedNames) + ".";
        this.logger.fine("The user " + player.getName() + " has " + auths.size() + " accounts:");
        this.logger.fine(message);
        for (Player onlinePlayer : this.bukkitService.getOnlinePlayers()) {
            if (onlinePlayer.getName().equalsIgnoreCase(player.getName()) && this.service.hasPermission(onlinePlayer, PlayerPermission.SEE_OWN_ACCOUNTS)) {
                this.service.send((CommandSender)onlinePlayer, MessageKey.ACCOUNTS_OWNED_SELF, Integer.toString(auths.size()));
                onlinePlayer.sendMessage(message);
                continue;
            }
            if (!this.service.hasPermission(onlinePlayer, AdminPermission.SEE_OTHER_ACCOUNTS)) continue;
            this.service.send((CommandSender)onlinePlayer, MessageKey.ACCOUNTS_OWNED_OTHER, player.getName(), Integer.toString(auths.size()));
            onlinePlayer.sendMessage(message);
        }
    }

    @VisibleForTesting
    boolean hasReachedMaxLoggedInPlayersForIp(Player player, String ip) {
        if (this.service.getProperty(RestrictionSettings.MAX_LOGIN_PER_IP) <= 0 || this.service.hasPermission(player, PlayerStatePermission.ALLOW_MULTIPLE_ACCOUNTS) || InternetProtocolUtils.isLoopbackAddress(ip)) {
            return false;
        }
        String name = player.getName();
        int count = 0;
        for (Player onlinePlayer : this.bukkitService.getOnlinePlayers()) {
            if (!ip.equalsIgnoreCase(PlayerUtils.getPlayerIp(onlinePlayer)) || onlinePlayer.getName().equals(name) || !this.dataSource.isLogged(onlinePlayer.getName().toLowerCase(Locale.ROOT))) continue;
            ++count;
        }
        return count >= this.service.getProperty(RestrictionSettings.MAX_LOGIN_PER_IP);
    }
}

