/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.permission.handlers;

import fr.xephi.authme.data.limbo.UserGroup;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsSystemType;
import fr.xephi.authme.permission.handlers.PermissionHandler;
import fr.xephi.authme.permission.handlers.PermissionHandlerException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.tyrannyofheaven.bukkit.zPermissions.ZPermissionsService;

public class ZPermissionsHandler
implements PermissionHandler {
    private ZPermissionsService zPermissionsService;

    public ZPermissionsHandler() throws PermissionHandlerException {
        ZPermissionsService zPermissionsService = (ZPermissionsService)Bukkit.getServicesManager().load(ZPermissionsService.class);
        if (zPermissionsService == null) {
            throw new PermissionHandlerException("Failed to get the ZPermissions service!");
        }
        this.zPermissionsService = zPermissionsService;
    }

    @Override
    public boolean addToGroup(OfflinePlayer player, UserGroup group) {
        return Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("permissions player " + player.getName() + " addgroup " + group.getGroupName()));
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    @Override
    public boolean hasPermissionOffline(String name, PermissionNode node) {
        Map perms = this.zPermissionsService.getPlayerPermissions(null, null, name);
        return perms.getOrDefault(node.getNode(), false);
    }

    @Override
    public boolean removeFromGroup(OfflinePlayer player, UserGroup group) {
        return Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("permissions player " + player.getName() + " removegroup " + group.getGroupName()));
    }

    @Override
    public boolean setGroup(OfflinePlayer player, UserGroup group) {
        return Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("permissions player " + player.getName() + " setgroup " + group.getGroupName()));
    }

    @Override
    public Collection<UserGroup> getGroups(OfflinePlayer player) {
        return this.zPermissionsService.getPlayerGroups(player.getName()).stream().map(UserGroup::new).collect(Collectors.toList());
    }

    @Override
    public UserGroup getPrimaryGroup(OfflinePlayer player) {
        return new UserGroup(this.zPermissionsService.getPlayerPrimaryGroup(player.getName()));
    }

    @Override
    public PermissionsSystemType getPermissionSystem() {
        return PermissionsSystemType.Z_PERMISSIONS;
    }
}

