/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.permission.handlers;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.data.limbo.UserGroup;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsSystemType;
import fr.xephi.authme.permission.handlers.PermissionHandler;
import fr.xephi.authme.permission.handlers.PermissionHandlerException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHandler
implements PermissionHandler {
    private Permission vaultProvider;

    public VaultHandler(Server server) throws PermissionHandlerException {
        this.vaultProvider = this.getVaultPermission(server);
    }

    @VisibleForTesting
    Permission getVaultPermission(Server server) throws PermissionHandlerException {
        RegisteredServiceProvider permissionProvider = server.getServicesManager().getRegistration(Permission.class);
        if (permissionProvider == null) {
            throw new PermissionHandlerException("Could not load permissions provider service");
        }
        Permission vaultPerms = (Permission)permissionProvider.getProvider();
        if (vaultPerms == null) {
            throw new PermissionHandlerException("Could not load Vault permissions provider");
        }
        return vaultPerms;
    }

    @Override
    public boolean addToGroup(OfflinePlayer player, UserGroup group) {
        return this.vaultProvider.playerAddGroup(null, player, group.getGroupName());
    }

    @Override
    public boolean hasGroupSupport() {
        return this.vaultProvider.hasGroupSupport();
    }

    @Override
    public boolean hasPermissionOffline(String name, PermissionNode node) {
        return this.vaultProvider.has((String)null, name, node.getNode());
    }

    @Override
    public boolean isInGroup(OfflinePlayer player, UserGroup group) {
        return this.vaultProvider.playerInGroup(null, player, group.getGroupName());
    }

    @Override
    public boolean removeFromGroup(OfflinePlayer player, UserGroup group) {
        return this.vaultProvider.playerRemoveGroup(null, player, group.getGroupName());
    }

    @Override
    public boolean setGroup(OfflinePlayer player, UserGroup group) {
        for (UserGroup g : this.getGroups(player)) {
            this.removeFromGroup(player, g);
        }
        return this.vaultProvider.playerAddGroup(null, player, group.getGroupName());
    }

    public List<UserGroup> getGroups(OfflinePlayer player) {
        String[] groups = this.vaultProvider.getPlayerGroups(null, player);
        return groups == null ? Collections.emptyList() : Arrays.stream(groups).map(UserGroup::new).collect(Collectors.toList());
    }

    @Override
    public UserGroup getPrimaryGroup(OfflinePlayer player) {
        return new UserGroup(this.vaultProvider.getPrimaryGroup(null, player));
    }

    @Override
    public PermissionsSystemType getPermissionSystem() {
        return PermissionsSystemType.VAULT;
    }
}

