/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.permission.handlers;

import fr.xephi.authme.data.limbo.UserGroup;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsSystemType;
import fr.xephi.authme.permission.handlers.PermissionHandler;
import fr.xephi.authme.permission.handlers.PermissionHandlerException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class PermissionsExHandler
implements PermissionHandler {
    private PermissionManager permissionManager = PermissionsEx.getPermissionManager();

    public PermissionsExHandler() throws PermissionHandlerException {
        if (this.permissionManager == null) {
            throw new PermissionHandlerException("Could not get manager of PermissionsEx");
        }
    }

    @Override
    public boolean addToGroup(OfflinePlayer player, UserGroup group) {
        if (!PermissionsEx.getPermissionManager().getGroupNames().contains(group)) {
            return false;
        }
        PermissionUser user = PermissionsEx.getUser((String)player.getName());
        user.addGroup(group.getGroupName());
        return true;
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    @Override
    public boolean hasPermissionOffline(String name, PermissionNode node) {
        PermissionUser user = this.permissionManager.getUser(name);
        return user.has(node.getNode());
    }

    @Override
    public boolean isInGroup(OfflinePlayer player, UserGroup group) {
        PermissionUser user = this.permissionManager.getUser(player.getName());
        return user.inGroup(group.getGroupName());
    }

    @Override
    public boolean removeFromGroup(OfflinePlayer player, UserGroup group) {
        PermissionUser user = this.permissionManager.getUser(player.getName());
        user.removeGroup(group.getGroupName());
        return true;
    }

    @Override
    public boolean setGroup(OfflinePlayer player, UserGroup group) {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(group.getGroupName());
        PermissionUser user = this.permissionManager.getUser(player.getName());
        user.setParentsIdentifier(groups);
        return true;
    }

    public List<UserGroup> getGroups(OfflinePlayer player) {
        PermissionUser user = this.permissionManager.getUser(player.getName());
        return user.getParentIdentifiers(null).stream().map(i -> new UserGroup((String)i, null)).collect(Collectors.toList());
    }

    @Override
    public PermissionsSystemType getPermissionSystem() {
        return PermissionsSystemType.PERMISSIONS_EX;
    }
}

