/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.permission;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.limbo.UserGroup;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsSystemType;
import fr.xephi.authme.permission.handlers.LuckPermsHandler;
import fr.xephi.authme.permission.handlers.PermissionHandler;
import fr.xephi.authme.permission.handlers.PermissionHandlerException;
import fr.xephi.authme.permission.handlers.PermissionLoadUserException;
import fr.xephi.authme.permission.handlers.PermissionsExHandler;
import fr.xephi.authme.permission.handlers.VaultHandler;
import fr.xephi.authme.permission.handlers.ZPermissionsHandler;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PermissionsManager
implements Reloadable {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(PermissionsManager.class);
    private final Server server;
    private final PluginManager pluginManager;
    private final Settings settings;
    private PermissionHandler handler = null;

    @Inject
    PermissionsManager(Server server, PluginManager pluginManager, Settings settings) {
        this.server = server;
        this.pluginManager = pluginManager;
        this.settings = settings;
    }

    public boolean isEnabled() {
        return this.handler != null;
    }

    @PostConstruct
    @VisibleForTesting
    void setup() {
        if (((Boolean)this.settings.getProperty(PluginSettings.FORCE_VAULT_HOOK)).booleanValue()) {
            try {
                PermissionHandler handler = this.createPermissionHandler(PermissionsSystemType.VAULT);
                if (handler != null) {
                    this.handler = handler;
                    this.logger.info("Hooked into " + PermissionsSystemType.VAULT.getDisplayName() + "!");
                    return;
                }
            }
            catch (PermissionHandlerException e) {
                this.logger.logException("Failed to create Vault hook (forced):", e);
            }
        } else {
            for (PermissionsSystemType type : PermissionsSystemType.values()) {
                try {
                    PermissionHandler handler = this.createPermissionHandler(type);
                    if (handler == null) continue;
                    this.handler = handler;
                    this.logger.info("Hooked into " + type.getDisplayName() + "!");
                    return;
                }
                catch (Exception ex) {
                    this.logger.logException("Error while hooking into " + type.getDisplayName(), ex);
                }
            }
        }
        this.logger.info("No supported permissions system found! Permissions are disabled!");
    }

    private PermissionHandler createPermissionHandler(PermissionsSystemType type) throws PermissionHandlerException {
        Plugin plugin = this.pluginManager.getPlugin(type.getPluginName());
        if (plugin == null) {
            return null;
        }
        if (!plugin.isEnabled()) {
            this.logger.info("Not hooking into " + type.getDisplayName() + " because it's disabled!");
            return null;
        }
        switch (type) {
            case LUCK_PERMS: {
                return new LuckPermsHandler();
            }
            case PERMISSIONS_EX: {
                return new PermissionsExHandler();
            }
            case Z_PERMISSIONS: {
                return new ZPermissionsHandler();
            }
            case VAULT: {
                return new VaultHandler(this.server);
            }
        }
        throw new IllegalStateException("Unhandled permission type '" + String.valueOf((Object)type) + "'");
    }

    private void unhook() {
        this.handler = null;
        this.logger.info("Unhooked from Permissions!");
    }

    @Override
    public void reload() {
        this.unhook();
        this.setup();
    }

    public void onPluginEnable(String pluginName) {
        if (PermissionsSystemType.isPermissionSystem(pluginName)) {
            this.logger.info(pluginName + " plugin enabled, dynamically updating permissions hooks!");
            this.setup();
        }
    }

    public void onPluginDisable(String pluginName) {
        if (PermissionsSystemType.isPermissionSystem(pluginName)) {
            this.logger.info(pluginName + " plugin disabled, updating hooks!");
            this.setup();
        }
    }

    public PermissionsSystemType getPermissionSystem() {
        return this.isEnabled() ? this.handler.getPermissionSystem() : null;
    }

    public boolean hasPermission(CommandSender sender, PermissionNode permissionNode) {
        if (permissionNode == null) {
            return true;
        }
        if (!(sender instanceof Player) || !this.isEnabled()) {
            return permissionNode.getDefaultPermission().evaluate((ServerOperator)sender);
        }
        Player player = (Player)sender;
        return player.hasPermission(permissionNode.getNode());
    }

    public boolean hasPermissionOffline(OfflinePlayer player, PermissionNode permissionNode) {
        if (permissionNode == null) {
            return true;
        }
        if (!this.isEnabled()) {
            return permissionNode.getDefaultPermission().evaluate((ServerOperator)player);
        }
        return this.handler.hasPermissionOffline(player.getName(), permissionNode);
    }

    public boolean hasPermissionOffline(String name, PermissionNode permissionNode) {
        if (permissionNode == null) {
            return true;
        }
        if (!this.isEnabled()) {
            return permissionNode.getDefaultPermission().evaluate(null);
        }
        return this.handler.hasPermissionOffline(name, permissionNode);
    }

    public boolean hasGroupSupport() {
        return this.isEnabled() && this.handler.hasGroupSupport();
    }

    public Collection<UserGroup> getGroups(OfflinePlayer player) {
        return this.isEnabled() ? this.handler.getGroups(player) : Collections.emptyList();
    }

    public UserGroup getPrimaryGroup(OfflinePlayer player) {
        return this.isEnabled() ? this.handler.getPrimaryGroup(player) : null;
    }

    public boolean isInGroup(OfflinePlayer player, UserGroup groupName) {
        return this.isEnabled() && this.handler.isInGroup(player, groupName);
    }

    public boolean addGroup(OfflinePlayer player, UserGroup groupName) {
        if (!this.isEnabled() || StringUtils.isBlank(groupName.getGroupName())) {
            return false;
        }
        return this.handler.addToGroup(player, groupName);
    }

    public boolean addGroups(OfflinePlayer player, Collection<UserGroup> groupNames) {
        if (!this.isEnabled()) {
            return false;
        }
        boolean result = false;
        for (UserGroup group : groupNames) {
            if (group.getGroupName().isEmpty()) continue;
            result |= this.handler.addToGroup(player, group);
        }
        return result;
    }

    public boolean removeGroup(OfflinePlayer player, UserGroup group) {
        return this.isEnabled() && this.handler.removeFromGroup(player, group);
    }

    public boolean removeGroups(OfflinePlayer player, Collection<UserGroup> groupNames) {
        if (!this.isEnabled()) {
            return false;
        }
        boolean result = false;
        for (UserGroup group : groupNames) {
            if (group.getGroupName().isEmpty()) continue;
            result |= this.handler.removeFromGroup(player, group);
        }
        return result;
    }

    public boolean setGroup(OfflinePlayer player, UserGroup group) {
        return this.isEnabled() && this.handler.setGroup(player, group);
    }

    public boolean removeAllGroups(OfflinePlayer player) {
        if (!this.isEnabled()) {
            return false;
        }
        Collection<UserGroup> groups = this.getGroups(player);
        return this.removeGroups(player, groups);
    }

    public boolean loadUserData(OfflinePlayer offlinePlayer) {
        try {
            this.loadUserData(offlinePlayer.getUniqueId());
        }
        catch (PermissionLoadUserException e) {
            this.logger.logException("Unable to load the permission data of user " + offlinePlayer.getName(), e);
            return false;
        }
        return true;
    }

    public void loadUserData(UUID uuid) throws PermissionLoadUserException {
        if (!this.isEnabled()) {
            return;
        }
        this.handler.loadUserData(uuid);
    }
}

